/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class IncreasingMetaspaceLiveSetRule
implements IRule {
    private static final String RESULT_ID = "IncreasingMetaSpaceLiveSet";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.MetaspaceSummary"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.MetaspaceSummary"});
        }
        IItemFilter afterFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.METASPACE_SUMMARY_AFTER_GC, JdkFilters.AFTER_GC});
        Iterator allAfterItems = items.apply(afterFilter).iterator();
        if (allAfterItems.hasNext()) {
            IItemIterable afterItems = (IItemIterable)allAfterItems.next();
            IMemberAccessor timeAccessor = JfrAttributes.END_TIME.getAccessor(afterItems.getType());
            IMemberAccessor memAccessor = JdkAttributes.GC_METASPACE_USED.getAccessor(afterItems.getType());
            double leastSquare = RulesToolkit.leastSquareMemory((Iterator)afterItems.iterator(), (IMemberAccessor)timeAccessor, (IMemberAccessor)memAccessor);
            double score = RulesToolkit.mapExp100((double)leastSquare, (double)0.75);
            if (score >= 25.0) {
                return new Result((IRule)this, score, Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_INFO"), Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_INFO_LONG"), JdkQueries.METASPACE_SUMMARY_AFTER_GC);
            }
            return new Result((IRule)this, score, Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_OK"), null, JdkQueries.METASPACE_SUMMARY_AFTER_GC);
        }
        return new Result((IRule)this, 0.0, Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_OK"), null, JdkQueries.METASPACE_SUMMARY_AFTER_GC);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return IncreasingMetaspaceLiveSetRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

