/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class IncreasingLiveSetRule
implements IRule {
    private static final String RESULT_ID = "IncreasingLiveSet";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.GCHeapSummary"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.GCHeapSummary"});
        }
        Iterator allAfterItems = items.apply(JdkFilters.HEAP_SUMMARY_AFTER_GC).iterator();
        double score = 0.0;
        if (allAfterItems.hasNext()) {
            IItemIterable afterItems = (IItemIterable)allAfterItems.next();
            IMemberAccessor timeAccessor = JfrAttributes.END_TIME.getAccessor(afterItems.getType());
            IMemberAccessor memAccessor = JdkAttributes.HEAP_USED.getAccessor(afterItems.getType());
            double memoryIncrease = RulesToolkit.leastSquareMemory((Iterator)afterItems.iterator(), (IMemberAccessor)timeAccessor, (IMemberAccessor)memAccessor);
            score = RulesToolkit.mapExp100((double)memoryIncrease, (double)0.75);
            if (score >= 25.0) {
                return new Result((IRule)this, score, Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO"), Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO_LONG"), JdkQueries.HEAP_SUMMARY_AFTER_GC);
            }
        }
        return new Result((IRule)this, score, Messages.getString("IncreasingLiveSetRuleFactory_TEXT_OK"), null, JdkQueries.HEAP_SUMMARY_AFTER_GC);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return IncreasingLiveSetRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("IncreasingLiveSetRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "heap";
    }
}

