/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.combine.SpanSquare;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class HighGcRule
implements IRule {
    private static final String RESULT_ID = "HighGc";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.GCPhasePause"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.GCPhasePause"});
        }
        SpanSquare longestGcCluster = HighGcRule.calculateLongestGcCluster(items.apply(JdkFilters.GC_PAUSE));
        if (longestGcCluster != null) {
            long sumPauseNanos = longestGcCluster.mass;
            long durationNanos = longestGcCluster.end - longestGcCluster.start;
            ITypedQuantity pausePercent = UnitLookup.PERCENT_UNITY.quantity((double)sumPauseNanos / (double)durationNanos);
            double score = RulesToolkit.mapExp100Y((double)sumPauseNanos, (double)1.0E9, (double)90.0);
            String startTime = KindOfQuantity.format((Number)longestGcCluster.start, (IUnit)UnitLookup.EPOCHNANOS);
            String duration = KindOfQuantity.format((Number)durationNanos, (IUnit)UnitLookup.NANOSECONDS);
            String message = MessageFormat.format(Messages.getString("HighGcRuleFactory_TEXT_INFO"), duration, startTime, pausePercent.displayUsing("auto"));
            if (!RulesToolkit.isEventsEnabled((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ObjectAllocationInNewTLAB", "com.oracle.jdk.ObjectAllocationOutsideTLAB"})) {
                return new Result((IRule)this, score, message, String.valueOf(Messages.getString("HighGcRuleFactory_TEXT_INFO_LONG")) + Messages.getString("HighGcRuleFactory_TEXT_INFO_LONG_ALLOC_DISABLED"), JdkQueries.GC_PAUSE);
            }
            return new Result((IRule)this, score, message, Messages.getString("HighGcRuleFactory_TEXT_INFO_LONG"), JdkQueries.GC_PAUSE);
        }
        return new Result((IRule)this, 0.0, Messages.getString("HighGcRuleFactory_TEXT_OK"), null, JdkQueries.GC_PAUSE);
    }

    private static SpanSquare calculateLongestGcCluster(IItemCollection items) {
        Iterator iiIterator = items.iterator();
        if (iiIterator.hasNext()) {
            IItemIterable ii = (IItemIterable)iiIterator.next();
            Iterator itemIt = ii.iterator();
            IType type = ii.getType();
            IMemberAccessor startTime = JfrAttributes.START_TIME.getAccessor(type);
            IMemberAccessor endTime = JfrAttributes.END_TIME.getAccessor(type);
            ArrayList<SpanSquare> gcs = new ArrayList<SpanSquare>();
            while (itemIt.hasNext()) {
                IItem item = (IItem)itemIt.next();
                long st = ((IQuantity)startTime.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.EPOCHNANOS);
                long et = ((IQuantity)endTime.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.EPOCHNANOS);
                gcs.add(new SpanSquare(st, et));
            }
            return SpanSquare.getMax(gcs.toArray(new SpanSquare[gcs.size()]));
        }
        return null;
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return HighGcRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HighGcRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "heap";
    }
}

