/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class HeapInspectionRule
implements IRule {
    private static final String HEAP_INSPECTION_RESULT_ID = "HeapInspectionGc";
    public static final TypedPreference<IQuantity> HEAP_INSPECTION_LIMIT = new TypedPreference("heap.inspection.info.limit", Messages.getString("HeapInspectionRule_CONFIG_WARNING_LIMIT"), Messages.getString("HeapInspectionRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(1L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(HEAP_INSPECTION_LIMIT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.GarbageCollection"});
                if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
                    return RulesToolkit.getEventAvailabilityResult((IRule)HeapInspectionRule.this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.GarbageCollection"});
                }
                GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)items.getAggregate(GarbageCollectionsInfo.GC_INFO_AGGREGATOR);
                return HeapInspectionRule.this.getHeapInspectionResult(aggregate.getObjectCountGCs(), items, (IQuantity)valueProvider.getPreferenceValue(HEAP_INSPECTION_LIMIT));
            }
        });
        return evaluationTask;
    }

    private Result getHeapInspectionResult(int objectCountGCs, IItemCollection items, IQuantity limit) {
        if (objectCountGCs > 0) {
            double score = RulesToolkit.mapExp74((double)objectCountGCs, (double)limit.longValue());
            String message = MessageFormat.format(Messages.getString("HeapInspectionGcRuleFactory_TEXT_INFO"), objectCountGCs);
            String longMessage = Messages.getString("HeapInspectionGcRuleFactory_TEXT_INFO_LONG");
            if (RulesToolkit.isEventsEnabled((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ObjectCount"})) {
                longMessage = String.valueOf(longMessage) + " " + Messages.getString("HeapInspectionGcRuleFactory_TEXT_INFO_LONG_JFR");
            }
            return new Result((IRule)this, score, message, longMessage, JdkQueries.GARBAGE_COLLECTION);
        }
        return new Result((IRule)this, 0.0, Messages.getString("HeapInspectionGcRuleFactory_TEXT_OK"));
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return HEAP_INSPECTION_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HeapInspectionGcRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

