/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.item.GroupingAggregator;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class HeapContentRule
implements IRule {
    private static final IAggregator<IQuantity, ?> HEAP_CONTENT_SCORE_AGGREGATOR = GroupingAggregator.build((String)Messages.getString("HeapContentRule_AGGR_CLASS_SCORE"), null, (IAccessorFactory)JdkAttributes.OBJECT_CLASS, (IAggregator)JdkAggregators.OBJECT_COUNT_MAX_SIZE, (GroupingAggregator.IQuantityListFinisher)new GroupingAggregator.IQuantityListFinisher<IQuantity>(){

        public IType<IQuantity> getValueType() {
            return UnitLookup.NUMBER;
        }

        public IQuantity getValue(List<IQuantity> t, IQuantity u) {
            double classScore = 0.0;
            int i = 0;
            while (i < t.size()) {
                classScore += t.get(i).doubleValue() / u.doubleValue() / (double)(t.size() - i);
                ++i;
            }
            return UnitLookup.NUMBER_UNITY.quantity(classScore);
        }
    });
    private static final String RESULT_ID = "HeapContent";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        double score;
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ObjectCount"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.ObjectCount"});
        }
        IQuantity aggregate = (IQuantity)items.getAggregate(HEAP_CONTENT_SCORE_AGGREGATOR);
        double d = score = aggregate == null ? 0.0 : RulesToolkit.mapExp100((double)aggregate.doubleValue(), (double)0.75);
        if (score >= 25.0) {
            return new Result((IRule)this, score, Messages.getString("HeapContentRuleFactory_TEXT_INFO"), Messages.getString("HeapContentRuleFactory_TEXT_INFO_LONG"), JdkQueries.OBJECT_COUNT);
        }
        return new Result((IRule)this, score, Messages.getString("HeapContentRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return HeapContentRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HeapContentRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "heap";
    }
}

