/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.memory.CollectorType;
import com.oracle.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class GcStallRule
implements IRule {
    private static final String GC_STALL_RESULT_ID = "GcStall";

    public RunnableFuture<Result> evaluate(final IItemCollection items, IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.GarbageCollection"});
                if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
                    return RulesToolkit.getEventAvailabilityResult((IRule)GcStallRule.this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.GarbageCollection"});
                }
                GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)items.getAggregate(GarbageCollectionsInfo.GC_INFO_AGGREGATOR);
                return GcStallRule.this.getGcStallResult(aggregate.foundNonRequestedSerialOldGc(), items);
            }
        });
        return evaluationTask;
    }

    private Result getGcStallResult(boolean nonRequestedSerialOldGc, IItemCollection items) {
        IQuantity c;
        if (nonRequestedSerialOldGc) {
            CollectorType oldCollectorType = CollectorType.getOldCollectorType(items);
            if (oldCollectorType == CollectorType.CMS) {
                return new Result((IRule)this, 100.0, Messages.getString("SerialOldRuleFactory_TEXT_WARN_CMS"), Messages.getString("SerialOldRuleFactory_TEXT_WARN_CMS_LONG"));
            }
            if (oldCollectorType == CollectorType.G1_OLD) {
                return new Result((IRule)this, 100.0, Messages.getString("SerialOldRuleFactory_TEXT_WARN_G1"), Messages.getString("SerialOldRuleFactory_TEXT_WARN_G1_LONG"));
            }
        }
        if ((c = (IQuantity)items.getAggregate(Aggregators.count(null, null, (IItemFilter)JdkFilters.CONCURRENT_MODE_FAILURE))) != null && c.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY) > 0L) {
            return new Result((IRule)this, 100.0, Messages.getString("ConcurrentFailedRuleFactory_TEXT_WARN"), Messages.getString("ConcurrentFailedRuleFactory_TEXT_WARN_LONG"), JdkQueries.CONCURRENT_MODE_FAILURE);
        }
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ConcurrentModeFailure", "com.oracle.jdk.GCConfiguration", "com.oracle.jdk.GarbageCollection"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.ConcurrentModeFailure", "com.oracle.jdk.GCConfiguration", "com.oracle.jdk.GarbageCollection"});
        }
        return new Result((IRule)this, 0.0, Messages.getString("GcStallRule_TEXT_OK"));
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return GC_STALL_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("GcStallRule_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

