/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemConsumer;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;

class GarbageCollectionsInfo
implements IItemConsumer<GarbageCollectionsInfo> {
    private final IMemberAccessor<String, IItem> causeAccessor;
    private final IMemberAccessor<String, IItem> nameAccessor;
    private int gcCount;
    private int systemGcCount;
    private int gcLockers;
    private int objectCountGCs;
    private boolean nonRequestedSerialOldGc;
    public static final IAggregator<GarbageCollectionsInfo, ?> GC_INFO_AGGREGATOR = new Aggregators.MergingAggregator<GarbageCollectionsInfo, GarbageCollectionsInfo>(null, null, (IType)UnitLookup.UNKNOWN){

        public boolean acceptType(IType<IItem> type) {
            return type.getIdentifier().equals("com.oracle.jdk.GarbageCollection");
        }

        public GarbageCollectionsInfo newItemConsumer(IType<IItem> type) {
            IMemberAccessor causeAccessor = JdkAttributes.GC_CAUSE.getAccessor(type);
            IMemberAccessor nameAccessor = JdkAttributes.GC_NAME.getAccessor(type);
            return new GarbageCollectionsInfo((IMemberAccessor<String, IItem>)causeAccessor, (IMemberAccessor<String, IItem>)nameAccessor);
        }

        public GarbageCollectionsInfo getValue(GarbageCollectionsInfo consumer) {
            return consumer == null ? new GarbageCollectionsInfo(null, null) : consumer;
        }
    };

    GarbageCollectionsInfo(IMemberAccessor<String, IItem> causeAccessor, IMemberAccessor<String, IItem> nameAccessor) {
        this.causeAccessor = causeAccessor;
        this.nameAccessor = nameAccessor;
    }

    public int getGcCount() {
        return this.gcCount;
    }

    public int getGcLockers() {
        return this.gcLockers;
    }

    public int getObjectCountGCs() {
        return this.objectCountGCs;
    }

    public int getSystemGcCount() {
        return this.systemGcCount;
    }

    public boolean foundNonRequestedSerialOldGc() {
        return this.nonRequestedSerialOldGc;
    }

    public void consume(IItem item) {
        String cause = (String)this.causeAccessor.getMember((Object)item);
        if ("Heap Inspection Initiated GC".equals(cause)) {
            ++this.objectCountGCs;
        } else if ("System.gc()".equals(cause)) {
            ++this.systemGcCount;
        } else {
            if ("gclocker".equalsIgnoreCase(cause)) {
                ++this.gcLockers;
            }
            if (!this.nonRequestedSerialOldGc && "SerialOld".equals(this.nameAccessor.getMember((Object)item))) {
                this.nonRequestedSerialOldGc = true;
            }
        }
        ++this.gcCount;
    }

    public GarbageCollectionsInfo merge(GarbageCollectionsInfo other) {
        this.gcCount += other.gcCount;
        this.systemGcCount += other.systemGcCount;
        this.gcLockers += other.gcLockers;
        this.objectCountGCs += other.objectCountGCs;
        this.nonRequestedSerialOldGc |= other.nonRequestedSerialOldGc;
        return this;
    }
}

