/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.BinaryPrefix;
import com.oracle.jmc.common.unit.IPrefix;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class CompressedOopsRule
implements IRule {
    private static final String RESULT_ID = "CompressedOops";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.BooleanFlag", "com.oracle.jdk.UnsignedLongFlag", "com.oracle.jdk.JVMInformation"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.BooleanFlag", "com.oracle.jdk.UnsignedLongFlag", "com.oracle.jdk.JVMInformation"});
        }
        Boolean compressedOops = (Boolean)items.getAggregate(JdkAggregators.USING_COMPRESSED_OOPS);
        IQuantity mx = (IQuantity)items.getAggregate(JdkAggregators.LARGEST_MAX_HEAP_SIZE_FROM_FLAG);
        String vmName = (String)items.getAggregate(JdkAggregators.JVM_NAME);
        if (compressedOops != null && mx != null && vmName != null && vmName.toUpperCase().contains("64-BIT") && mx.compareTo((Object)UnitLookup.NUMBER.getUnit((IPrefix)BinaryPrefix.GIBI).quantity(32L)) > 0 && !compressedOops.booleanValue()) {
            return new Result((IRule)this, 50.0, Messages.getString("CompressedOopsRuleFactory_TEXT_INFO"), Messages.getString("CompressedOopsRuleFactory_TEXT_INFO_LONG"));
        }
        return new Result((IRule)this, 0.0, Messages.getString("CompressedOopsRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return CompressedOopsRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("CompressedOopsRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "gc_configuration";
    }
}

