/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.IMCType;
import com.oracle.jmc.common.collection.MapToolkit;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.util.FormatToolkit;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.owasp.encoder.Encode;

public class AllocationByClassRule
implements IRule {
    private static final String CLASS_RESULT_ID = "Allocations.class";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ObjectAllocationInNewTLAB"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.ObjectAllocationInNewTLAB"});
        }
        List entries = RulesToolkit.calculateGroupingScore((IItemCollection)items.apply(JdkFilters.ALLOC_INSIDE_TLAB), (IAccessorFactory)JdkAttributes.ALLOCATION_CLASS);
        double balance = RulesToolkit.calculateBalanceScore((List)entries);
        MapToolkit.IntEntry mostSignificant = (MapToolkit.IntEntry)entries.get(entries.size() - 1);
        double relevance = RulesToolkit.mapExp100Y((double)mostSignificant.getValue(), (double)1000.0, (double)50.0);
        double score = balance * relevance * 0.74;
        String message = MessageFormat.format(Messages.getString("AllocationByClassRule_TEXT_MESSAGE"), Encode.forHtml(FormatToolkit.getType((IMCType)((IMCType)mostSignificant.key), (boolean)true)));
        return new Result((IRule)this, score, message, Messages.getString("AllocationRuleFactory_TEXT_CLASS_INFO_LONG"), JdkQueries.ALLOC_INSIDE_TLAB_BY_CLASS);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return AllocationByClassRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return CLASS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("AllocationByClassRule_RULE_NAME");
    }

    public String getTopic() {
        return "heap";
    }
}

