/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.latency;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.Pair;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.dataproviders.MethodProfilingDataProvider;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class MethodProfilingRule
implements IRule {
    private static final double SAMPLES_PER_PERIOD = 5.0;
    private static final String RESULT_ID = "MethodProfiling";
    public static final TypedPreference<IQuantity> WINDOW_SIZE = new TypedPreference("method.profiling.evaluation.window.size", Messages.getString("MethodProfilingRule_WINDOW_SIZE"), Messages.getString("MethodProfilingRule_WINDOW_SIZE_DESC"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECONDS.quantity(30L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WINDOW_SIZE);
    private FutureTask<Result> evaluationTask;

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        this.evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return MethodProfilingRule.this.getResult(items, valueProvider);
            }
        });
        return this.evaluationTask;
    }

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ExecutionSample", "com.oracle.jdk.ActiveSetting"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.ExecutionSample", "com.oracle.jdk.ActiveSetting"});
        }
        PeriodRangeMap settings = new PeriodRangeMap();
        IItemFilter settingsFilter = RulesToolkit.getSettingsFilter((String)"period", (String[])new String[]{"com.oracle.jdk.ExecutionSample"});
        this.populateSettingsMap(items.apply(settingsFilter), settings);
        IQuantity windowSize = (IQuantity)valueProvider.getPreferenceValue(WINDOW_SIZE);
        ITypedQuantity slideSize = UnitLookup.SECONDS.quantity(windowSize.ratioTo((IQuantity)UnitLookup.SECONDS.quantity(2L)));
        ArrayList<Double> rawScores = new ArrayList<Double>();
        RulesToolkit.IUnorderedWindowVisitor visitor = this.createWindowVisitor(settings, settingsFilter, windowSize, rawScores);
        RulesToolkit.slidingWindowUnordered((RulesToolkit.IUnorderedWindowVisitor)visitor, (IItemCollection)items, (IQuantity)windowSize, (IQuantity)slideSize);
        if (rawScores.isEmpty()) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (String)Messages.getString("HotMethodsRuleFactory_NOT_ENOUGH_SAMPLES"));
        }
        Double maxRawScore = Collections.max(rawScores);
        double mappedScore = RulesToolkit.mapSigmoid((double)maxRawScore, (double)0.0, (double)100.0, (double)150.0, (double)0.03333, (double)7.0);
        if (mappedScore < 25.0) {
            return new Result((IRule)this, mappedScore, Messages.getString("HotMethodsRuleFactory_TEXT_OK"));
        }
        return new Result((IRule)this, mappedScore, Messages.getString("HotMethodsRuleFactory_TEXT_INFO"), Messages.getString("HotMethodsRuleFactory_TEXT_INFO_LONG"));
    }

    private RulesToolkit.IUnorderedWindowVisitor createWindowVisitor(final PeriodRangeMap settings, final IItemFilter settingsFilter, final IQuantity windowSize, final List<Double> rawScores) {
        return new RulesToolkit.IUnorderedWindowVisitor(){

            public void visitWindow(IItemCollection items, IQuantity startTime, IQuantity endTime) {
                if (RulesToolkit.getSettingMaxPeriod((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ExecutionSample"}) == null) {
                    rawScores.add(this.performCalculation(items, settings.getSetting(startTime)));
                } else {
                    Set settingTimes = (Set)items.apply(settingsFilter).getAggregate(Aggregators.distinct((IAttribute)JfrAttributes.START_TIME));
                    IQuantity start = startTime;
                    ArrayList<Double> scores = new ArrayList<Double>(settingTimes.size());
                    for (IQuantity settingTime : settingTimes) {
                        IItemFilter window = ItemFilters.interval((ICanonicalAccessorFactory)JfrAttributes.END_TIME, (Comparable)start, (boolean)true, (Comparable)settingTime, (boolean)true);
                        scores.add(this.performCalculation(items.apply(window), settings.getSetting(start)));
                        start = settingTime;
                    }
                    double sum = 0.0;
                    for (Double score : scores) {
                        sum += score.doubleValue();
                    }
                    rawScores.add(sum / (double)scores.size());
                }
            }

            public boolean shouldContinue() {
                return !MethodProfilingRule.this.evaluationTask.isCancelled();
            }

            private double performCalculation(IItemCollection items, IQuantity period) {
                IQuantity balance = (IQuantity)items.getAggregate(MethodProfilingDataProvider.TOP_FRAME_QUOTA);
                if (balance != null && period != null) {
                    double maxSamplesPerSecond = 5.0 / period.doubleValueIn((IUnit)UnitLookup.SECONDS);
                    double relevancy = ((IQuantity)items.getAggregate(Aggregators.count((IItemFilter)ItemFilters.type((String)"com.oracle.jdk.ExecutionSample")))).doubleValue() / windowSize.doubleValue() / maxSamplesPerSecond;
                    return balance.doubleValue() * relevancy;
                }
                return 0.0;
            }
        };
    }

    private void populateSettingsMap(IItemCollection items, PeriodRangeMap settings) {
        for (IItemIterable itemIterable : items) {
            IMemberAccessor startTimeAccessor = JfrAttributes.START_TIME.getAccessor(itemIterable.getType());
            IMemberAccessor settingValueAccessor = JdkAttributes.REC_SETTING_VALUE.getAccessor(itemIterable.getType());
            for (IItem item : itemIterable) {
                settings.addSetting((IQuantity)startTimeAccessor.getMember((Object)item), this.getValueQuantity((String)settingValueAccessor.getMember((Object)item)));
            }
        }
        settings.sort();
    }

    private IQuantity getValueQuantity(String settingValue) {
        block3: {
            try {
                if (!"everyChunk".equals(settingValue)) break block3;
                return null;
            }
            catch (QuantityConversionException e) {
                throw new RuntimeException(e);
            }
        }
        return RulesToolkit.parsePersistedJvmTimespan((String)settingValue);
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("MethodProfilingRule_RULE_NAME");
    }

    public String getTopic() {
        return "java_application";
    }

    private static class PeriodRangeMap {
        private List<Pair<IQuantity, IQuantity>> settingPairs = new ArrayList<Pair<IQuantity, IQuantity>>();

        private PeriodRangeMap() {
        }

        void addSetting(IQuantity settingTime, IQuantity setting) {
            this.settingPairs.add((Pair<IQuantity, IQuantity>)new Pair((Object)settingTime, (Object)setting));
        }

        IQuantity getSetting(IQuantity timestamp) {
            for (Pair<IQuantity, IQuantity> settingPair : this.settingPairs) {
                boolean isAfterOrAtSettingTime;
                boolean bl = isAfterOrAtSettingTime = ((IQuantity)settingPair.left).compareTo((Object)timestamp) <= 0;
                if (!isAfterOrAtSettingTime) continue;
                return (IQuantity)settingPair.right;
            }
            return null;
        }

        void sort() {
            Collections.sort(this.settingPairs, new Comparator<Pair<IQuantity, IQuantity>>(){

                @Override
                public int compare(Pair<IQuantity, IQuantity> p1, Pair<IQuantity, IQuantity> p2) {
                    return ((IQuantity)p1.left).compareTo((Object)((IQuantity)p2.left));
                }
            });
        }
    }
}

