/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.latency;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.GroupingAggregator;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class ContextSwitchRule
implements IRule {
    public static final TypedPreference<IQuantity> CONTEXT_SWITCH_WARNING_LIMIT = new TypedPreference("contextswitch.warning.limit", Messages.getString("ContextSwitchRule_CONFIG_WARNING_LIMIT"), Messages.getString("ContextSwitchRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(10000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(CONTEXT_SWITCH_WARNING_LIMIT);
    private static final String RESULT_ID = "ContextSwitch";
    private static final IAggregator<IQuantity, ?> MAX_BLOCKS = GroupingAggregator.buildMax((String)Messages.getString("ContextSwitchRule_AGGR_MAX_BLOCKS"), null, (IAccessorFactory)JdkAttributes.MONITOR_ADDRESS, (IAggregator)JdkAggregators.TOTAL_BLOCKED_COUNT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider vp) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return ContextSwitchRule.this.evaluate(items, ((IQuantity)vp.getPreferenceValue(CONTEXT_SWITCH_WARNING_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY));
            }
        });
        return evaluationTask;
    }

    private Result evaluate(IItemCollection items, long switchRateLimit) {
        String longText;
        String text;
        int warningLimit;
        int infoLimit;
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ThreadContextSwitchRate"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.ThreadContextSwitchRate"});
        }
        long switchRate = ContextSwitchRule.calculateSwitchRate(items);
        if (switchRate == -1L) {
            return RulesToolkit.getTooFewEventsResult((IRule)this);
        }
        long mostBlocks = switchRate > switchRateLimit ? ContextSwitchRule.getMostBlocks(items) : 0L;
        double score = RulesToolkit.mapExp100((double)mostBlocks, (double)(infoLimit = (warningLimit = 100) / 2), (double)warningLimit);
        if (score < 25.0) {
            text = Messages.getString("ContextSwitchRuleFactory_TEXT_OK");
            longText = null;
        } else {
            text = Messages.getString("ContextSwitchRuleFactory_TEXT_INFO");
            longText = Messages.getString("ContextSwitchRuleFactory_TEXT_INFO_LONG");
        }
        return new Result((IRule)this, score, text, longText);
    }

    private static long calculateSwitchRate(IItemCollection switchItems) {
        IQuantity aggregate = (IQuantity)switchItems.getAggregate(Aggregators.avg((String)"com.oracle.jdk.ThreadContextSwitchRate", (IAttribute)JdkAttributes.OS_SWITCH_RATE));
        return aggregate == null ? -1L : aggregate.longValue();
    }

    private static long getMostBlocks(IItemCollection items) {
        IQuantity aggregate = (IQuantity)items.getAggregate(MAX_BLOCKS);
        return aggregate == null ? 0L : aggregate.longValue();
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ContextSwitchRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "lock_instances";
    }
}

