/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.latency;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class BiasedLockingRevocationRule
implements IRule {
    public static final TypedPreference<IQuantity> INFO_LIMIT = new TypedPreference("vm.biasedrevocation.info.limit", Messages.getString("BiasedLockingRevocationRule_CONFIG_WARNING_LIMIT"), Messages.getString("BiasedLockingRevocationRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECONDS.quantity(100L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(INFO_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ExecuteVMOperation"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.ExecuteVMOperation"});
        }
        IItemCollection revocationEvents = items.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.VM_OPERATIONS, ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.OPERATION, (String)"RevokeBias")}));
        if (!revocationEvents.hasItems()) {
            return new Result((IRule)this, 0.0, Messages.getString("BiasedLockingRevocationRule_TEXT_OK"));
        }
        ITypedQuantity timeSpentRevoking = revocationEvents.hasItems() ? (IQuantity)revocationEvents.getAggregate(Aggregators.sum((IAttribute)JfrAttributes.DURATION)) : UnitLookup.MILLISECONDS.quantity(0L);
        double mappedDuration = RulesToolkit.mapExp100Y((double)timeSpentRevoking.doubleValueIn((IUnit)UnitLookup.MILLISECONDS), (double)((IQuantity)valueProvider.getPreferenceValue(INFO_LIMIT)).doubleValueIn((IUnit)UnitLookup.MILLISECONDS), (double)25.0);
        return new Result((IRule)this, mappedDuration, MessageFormat.format(Messages.getString("BiasedLockingRevocationRule_TEXT_MESSAGE"), timeSpentRevoking.displayUsing("auto")), mappedDuration >= 25.0 ? Messages.getString("BiasedLockingRevocationRule_TEXT_INFO_LONG") : null);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return BiasedLockingRevocationRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return "biasedLockingRevocation";
    }

    public String getName() {
        return Messages.getString("BiasedLockingRevocationRule_RULE_NAME");
    }

    public String getTopic() {
        return "vm_operations";
    }
}

