/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.io;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.Severity;
import com.oracle.jmc.flightrecorder.rules.jdk.io.SocketReadRule;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class SocketWriteRule
implements IRule {
    private static final String RESULT_ID = "SocketWrite";
    public static final TypedPreference<IQuantity> WRITE_INFO_LIMIT = new TypedPreference("io.socket.write.info.limit", Messages.getString("SocketWriteRule_CONFIG_INFO_LIMIT"), Messages.getString("SocketWriteRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECONDS.quantity(275L));
    public static final TypedPreference<IQuantity> WRITE_WARNING_LIMIT = new TypedPreference("io.socket.write.warning.limit", Messages.getString("SocketWriteRule_CONFIG_WARNING_LIMIT"), Messages.getString("SocketWriteRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECONDS.quantity(2000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WRITE_INFO_LIMIT, WRITE_WARNING_LIMIT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider vp) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return SocketWriteRule.this.evaluate(items, (IQuantity)vp.getPreferenceValue(WRITE_INFO_LIMIT), (IQuantity)vp.getPreferenceValue(WRITE_WARNING_LIMIT));
            }
        });
        return evaluationTask;
    }

    private Result evaluate(IItemCollection items, IQuantity infoLimit, IQuantity warningLimit) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.SocketWrite"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.SocketWrite"});
        }
        IItem longestEvent = (IItem)items.apply(JdkFilters.NO_RMI_SOCKET_WRITE).getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        if (longestEvent == null) {
            return new Result((IRule)this, 0.0, MessageFormat.format(Messages.getString("SocketWriteRuleFactory_TEXT_OK"), "0"), Messages.getString("SocketWriteRuleFactory_TEXT_OK_LONG"), JdkQueries.NO_RMI_SOCKET_WRITE);
        }
        IQuantity maxDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        String peakDuration = maxDuration.displayUsing("auto");
        double score = RulesToolkit.mapExp100((double)maxDuration.doubleValueIn((IUnit)UnitLookup.SECONDS), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECONDS), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECONDS));
        if (Severity.get((double)score) == Severity.WARNING || Severity.get((double)score) == Severity.INFO) {
            String address = SocketReadRule.sanitizeAddress((String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_ADDRESS));
            String amountWritten = ((IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_SOCKET_BYTES_WRITTEN)).displayUsing("auto");
            return new Result((IRule)this, score, MessageFormat.format(Messages.getString("SocketWriteRuleFactory_TEXT_WARN"), peakDuration), MessageFormat.format(Messages.getString("SocketWriteRuleFactory_TEXT_WARN_LONG"), peakDuration, address, amountWritten));
        }
        return new Result((IRule)this, 0.0, MessageFormat.format(Messages.getString("SocketWriteRuleFactory_TEXT_OK"), peakDuration), Messages.getString("SocketWriteRuleFactory_TEXT_OK_LONG"), JdkQueries.NO_RMI_SOCKET_WRITE);
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("SocketWriteRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "socket_io";
    }
}

