/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.io;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.Severity;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.owasp.encoder.Encode;

public class SocketReadRule
implements IRule {
    private static final String RESULT_ID = "SocketRead";
    public static final TypedPreference<IQuantity> READ_INFO_LIMIT = new TypedPreference("io.socket.read.info.limit", Messages.getString("SocketReadRule_CONFIG_INFO_LIMIT"), Messages.getString("SocketReadRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECONDS.quantity(275L));
    public static final TypedPreference<IQuantity> READ_WARNING_LIMIT = new TypedPreference("io.socket.read.warning.limit", Messages.getString("SocketReadRule_CONFIG_WARNING_LIMIT"), Messages.getString("SocketReadRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECONDS.quantity(2000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(READ_INFO_LIMIT, READ_WARNING_LIMIT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider vp) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return SocketReadRule.this.evaluate(items, (IQuantity)vp.getPreferenceValue(READ_INFO_LIMIT), (IQuantity)vp.getPreferenceValue(READ_WARNING_LIMIT));
            }
        });
        return evaluationTask;
    }

    private Result evaluate(IItemCollection items, IQuantity infoLimit, IQuantity warningLimit) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.SocketRead"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.SocketRead"});
        }
        IItemCollection readItems = items.apply(JdkFilters.NO_RMI_SOCKET_READ);
        IType readType = RulesToolkit.getType((IItemCollection)readItems, (String)"com.oracle.jdk.SocketRead");
        if (!readType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.IO_ADDRESS)) {
            return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)readType, (IAttribute)JdkAttributes.IO_ADDRESS);
        }
        IItem longestEvent = (IItem)readItems.getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        if (longestEvent == null) {
            return new Result((IRule)this, 0.0, MessageFormat.format(Messages.getString("SocketReadRuleFactory_TEXT_OK"), "0"), Messages.getString("SocketReadRuleFactory_TEXT_OK_LONG"), JdkQueries.NO_RMI_SOCKET_READ);
        }
        IQuantity maxDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        String peakDuration = maxDuration.displayUsing("auto");
        double score = RulesToolkit.mapExp100((double)maxDuration.doubleValueIn((IUnit)UnitLookup.SECONDS), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECONDS), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECONDS));
        if (Severity.get((double)score) == Severity.WARNING || Severity.get((double)score) == Severity.INFO) {
            String address = SocketReadRule.sanitizeAddress((String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_ADDRESS));
            String amountRead = ((IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_SOCKET_BYTES_READ)).displayUsing("auto");
            return new Result((IRule)this, score, MessageFormat.format(Messages.getString("SocketReadRuleFactory_TEXT_WARN"), maxDuration.displayUsing("auto")), MessageFormat.format(Messages.getString("SocketReadRuleFactory_TEXT_WARN_LONG"), peakDuration, address, amountRead), JdkQueries.NO_RMI_SOCKET_READ);
        }
        return new Result((IRule)this, 0.0, MessageFormat.format(Messages.getString("SocketReadRuleFactory_TEXT_OK"), peakDuration), Messages.getString("SocketReadRuleFactory_TEXT_OK_LONG"), JdkQueries.NO_RMI_SOCKET_READ);
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("SocketReadRuleFactory_RULE_NAME");
    }

    protected static String sanitizeAddress(String address) {
        if (address == null || address.isEmpty()) {
            return Encode.forHtml(Messages.getString("General_UNKNOWN_ADDRESS"));
        }
        return Encode.forHtml(address);
    }

    public String getTopic() {
        return "socket_io";
    }
}

