/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.io;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.Severity;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.owasp.encoder.Encode;

public class FileReadRule
implements IRule {
    public static final TypedPreference<IQuantity> READ_WARNING_LIMIT = new TypedPreference("io.file.read.warning.limit", Messages.getString("FileReadRule_CONFIG_WARNING_LIMIT"), Messages.getString("FileReadRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECONDS.quantity(4000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(READ_WARNING_LIMIT);
    private static final String RESULT_ID = "FileRead";

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.FileRead"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.FileRead"});
        }
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(READ_WARNING_LIMIT);
        IQuantity infoLimit = warningLimit.multiply(0.5);
        IItem longestEvent = (IItem)items.apply(JdkFilters.FILE_READ).getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        if (longestEvent == null) {
            return new Result((IRule)this, 0.0, MessageFormat.format(Messages.getString("FileReadRuleFactory_TEXT_OK"), "0"), null, JdkQueries.FILE_READ);
        }
        IQuantity longestDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        String peakDuration = longestDuration.displayUsing("auto");
        double score = RulesToolkit.mapExp100((double)longestDuration.doubleValueIn((IUnit)UnitLookup.SECONDS), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECONDS), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECONDS));
        if (Severity.get((double)score) == Severity.WARNING || Severity.get((double)score) == Severity.INFO) {
            String fileName = FileReadRule.sanitizeFileName((String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_PATH));
            String amountRead = ((IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_FILE_BYTES_READ)).displayUsing("auto");
            return new Result((IRule)this, score, MessageFormat.format(Messages.getString("FileReadRuleFactory_TEXT_WARN"), peakDuration), MessageFormat.format(Messages.getString("FileReadRuleFactory_TEXT_WARN_LONG"), peakDuration, fileName, amountRead), JdkQueries.FILE_READ);
        }
        return new Result((IRule)this, score, MessageFormat.format(Messages.getString("FileReadRuleFactory_TEXT_OK"), peakDuration), null, JdkQueries.FILE_READ);
    }

    static String sanitizeFileName(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return Encode.forHtml(Messages.getString("General_UNKNOWN_FILE_NAME"));
        }
        return Encode.forHtml(fileName);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return FileReadRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("FileReadRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "file_io";
    }
}

