/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.general;

import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.owasp.encoder.Encode;

public class RecordingSettingsRule
implements IRule {
    private static final String RECORDING_SETTINGS_RESULT_ID = "OverAggressiveRecordingSetting";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.InitialSystemProperty"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.InitialSystemProperty"});
        }
        String names = RulesToolkit.getTypesWithZeroThreshold((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ThreadPark", "com.oracle.jdk.JavaMonitorEnter"});
        if (names != null && names.length() > 0) {
            String eventsWithoutThreshold = names.trim();
            return new Result((IRule)this, 50.0, MessageFormat.format(Messages.getString("OverAggressiveRecordingSettingRuleFactory_TEXT_INFO"), Encode.forHtml(eventsWithoutThreshold)), Messages.getString("OverAggressiveRecordingSettingRuleFactory_TEXT_INFO_LONG"), JdkQueries.RECORDING_SETTINGS);
        }
        return new Result((IRule)this, 0.0, Messages.getString("OverAggressiveRecordingSettingRuleFactory_RULE_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return RecordingSettingsRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RECORDING_SETTINGS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("OverAggressiveRecordingSettingRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "recording";
    }
}

