/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.general;

import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.owasp.encoder.Encode;

public class PasswordsInEnvironmentRule
implements IRule {
    private static final String PWD_RESULT_ID = "PasswordsInEnvironment";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.InitialEnvironmentVariable"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.InitialEnvironmentVariable"});
        }
        String pwds = RulesToolkit.findMatches((String)"com.oracle.jdk.InitialEnvironmentVariable", (IItemCollection)items, (IAttribute)JdkAttributes.ENVIRONMENT_KEY, (String)"PASSW", (boolean)true);
        if (pwds != null && pwds.length() > 0) {
            String message = MessageFormat.format(Messages.getString("PasswordsInEnvironmentRuleFactory_TEXT_INFO_LONG"), Encode.forHtml(pwds));
            return new Result((IRule)this, 100.0, Messages.getString("PasswordsInEnvironmentRuleFactory_TEXT_INFO"), message);
        }
        return new Result((IRule)this, 0.0, Messages.getString("PasswordsInEnvironmentRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return PasswordsInEnvironmentRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return PWD_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("PasswordsInEnvironmentRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "environment_variables";
    }
}

