/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.general;

import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.common.version.JavaVersion;
import com.oracle.jmc.common.version.JavaVersionSupport;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.encoder.Encode;

public class OptionsCheckRule
implements IRule {
    private static final String RESULT_ID = "Options";
    private static final Pattern XX_OPTION_PATTERN = Pattern.compile("-XX:(?:[+-])?(\\w+)(?:=.*)?");
    private static final String[] JAVA_7_DOCUMENTED_XX = new String[]{"AggressiveOpts", "PrintCompilation", "PrintGCDetails", "PrintGCTimeStamps", "UnlockCommercialFeatures", "UseConcMarkSweepGC", "UseG1GC", "UseParallelOldGC", "AllocationPrefetchStyle", "FlightRecorderOptions", "MaxGCPauseMillis", "NewSize", "ParallelGCThreads", "PredictedClassLoadCount", "SoftRefLRUPolicyMSPerMB", "StartFlightRecording", "TLABSize", "DisableAttachMechanism", "FlightRecorder", "UseCompressedOops", "UseLargePages", "LargePageSizeInBytes"};
    private static final String[] JAVA_8_DOCUMENTED_XX = new String[]{"CheckEndorsedAndExtDirs", "DisableAttachMechanism", "ErrorFile", "FailOverToOldVerifier", "FlightRecorder", "FlightRecorderOptions", "LargePageSizeInBytes", "MaxDirectMemorySize", "NativeMemoryTracking", "ObjectAlignmentInBytes", "OnError", "OnOutOfMemoryError", "PerfDataSaveToFile", "PrintCommandLineFlags", "PrintNMTStatistics", "RelaxAccessControlCheck", "ResourceManagement", "ResourceManagementSampleInterval", "SharedArchiveFile", "SharedClassListFile", "ShowMessageBoxOnError", "StartFlightRecording", "ThreadStackSize", "TraceClassLoading", "TraceClassLoadingPreorder", "TraceClassResolution", "TraceClassUnloading", "TraceLoaderConstraints", "UnlockCommercialFeatures", "UseAppCDS", "UseBiasedLocking", "UseCompressedOops", "UseLargePages", "UseMembar", "UsePerfData", "AllowUserSignalHandlers", "AggressiveOpts", "AllocateInstancePrefetchLines", "AllocatePrefetchDistance", "AllocatePrefetchInstr", "AllocatePrefetchLines", "AllocatePrefetchStepSize", "AllocatePrefetchStyle", "BackgroundCompilation", "CICompilerCount", "CodeCacheMinimumFreeSpace", "CompileCommand", "CompileCommandFile", "CompileOnly", "CompileThreshold", "DoEscapeAnalysis", "InitialCodeCacheSize", "Inline", "InlineSmallCode", "LogCompilation", "MaxInlineSize", "MaxNodeLimit", "MaxTrivialSize", "OptimizeStringConcat", "PrintAssembly", "PrintCompilation", "PrintInlining", "ReservedCodeCacheSize", "RTMAbortRatio", "RTMRetryCount", "TieredCompilation", "UseAES", "UseAESIntrinsics", "UseCodeCacheFlushing", "UseCondCardMark", "UseRTMDeopt", "UseRTMLocking", "UseSHA", "UseSHA1Intrinsics", "UseSHA256Intrinsics", "UseSHA512Intrinsics", "UseSuperWord", "HeapDumpOnOutOfMemory", "HeapDumpPath", "LogFile", "PrintClassHistogram", "PrintConcurrentLocks", "UnlockDiagnosticVMOptions", "AggressiveHeap", "AlwaysPreTouch", "CMSClassUnloadingEnabled", "CMSExpAvgFactor", "CMSInitiatingOccupancyFraction", "CMSScavengeBeforeRemark", "CMSTriggerRatio", "ConcGCThreads", "DisableExplicitGC", "ExplicitGCInvokesConcurrent", "ExplicitGCInvokesConcurrentAndUnloadsClasses", "G1HeapRegionSize", "G1PrintHeapRegions", "G1ReservePercent", "InitialHeapSize", "InitialSurvivorRatio", "InitiatingHeapOccupancyPercent", "MaxGCPauseMillis", "MaxHeapSize", "MaxHeapFreeRatio", "MaxMetaspaceSize", "MaxNewSize", "MaxTenuringThreshold", "MetaspaceSize", "MinHeapFreeRatio", "NewRatio", "NewSize", "ParallelGCThreads", "ParallelRefProcEnabled", "PrintAdaptiveSizePolicy", "PrintGC", "PrintGCApplicationConcurrentTime", "PrintGCApplicationStoppedTime", "PrintGCDateStamps", "PrintGCDetails", "PrintGCTaskTimeStamps", "PrintGCTimeStamps", "PrintStringDeduplicationStatistics", "PrintTenuringDistribution", "ScavengeBeforeFullGC", "SoftRefLRUPolicyMSPerMB", "StringDeduplicationAgeThreshold", "SurvivorRatio", "TargetSurvivorRatio", "TLABSize", "UseAdaptiveSizePolicy", "UseCMSInitiatingOccupancyOnly", "UseConcMarkSweepGC", "UseG1GC", "UseGCOverheadLimit", "UseNUMA", "UseParallelGC", "UseParallelOldGC", "UseParNewGC", "UseSerialGC", "UseStringDeduplication", "UseTLAB"};
    private static final DeprecatedOption[] DEPRECATED_OPTIONS_XX = new DeprecatedOption[]{new DeprecatedOption("HandlePromotionFailure", null, JavaVersionSupport.JDK_7, JavaVersionSupport.JDK_8), new DeprecatedOption("MaxLiveObjectEvacuationRatio", null, JavaVersionSupport.JDK_7, JavaVersionSupport.JDK_8), new DeprecatedOption("ForceSharedSpaces", null, JavaVersionSupport.JDK_7, JavaVersionSupport.JDK_8), new DeprecatedOption("UseParallelOldGCCompacting", null, JavaVersionSupport.JDK_7, JavaVersionSupport.JDK_8), new DeprecatedOption("UseParallelDensePrefixUpdate", null, JavaVersionSupport.JDK_7, JavaVersionSupport.JDK_8), new DeprecatedOption("UseParallelOldGCDensePrefix", null, JavaVersionSupport.JDK_7, JavaVersionSupport.JDK_8), new DeprecatedOption("AllowTransitionalJSR292", null, JavaVersionSupport.JDK_7, JavaVersionSupport.JDK_8), new DeprecatedOption("MaxGCMinorPauseMillis", JavaVersionSupport.JDK_8, null, null), new DeprecatedOption("DefaultMaxRAMFraction", JavaVersionSupport.JDK_8, null, null, Messages.getString("OptionsCheckRule_TEXT_USE_MAXRAMFRACTION")), new DeprecatedOption("UseCMSCompactAtFullCollection", JavaVersionSupport.JDK_8, null, null), new DeprecatedOption("CMSFullGCsBeforeCompaction", JavaVersionSupport.JDK_8, null, null), new DeprecatedOption("UseCMSCollectionPassing", JavaVersionSupport.JDK_8, null, null), new DeprecatedOption("CMSIncrementalDutyCycle", JavaVersionSupport.JDK_8, null, JavaVersionSupport.JDK_9), new DeprecatedOption("CMSIncrementalDutyCycleMin", JavaVersionSupport.JDK_8, null, JavaVersionSupport.JDK_9), new DeprecatedOption("CMSIncrementalMode", JavaVersionSupport.JDK_8, null, JavaVersionSupport.JDK_9), new DeprecatedOption("CMSIncrementalOffset", JavaVersionSupport.JDK_8, null, JavaVersionSupport.JDK_9), new DeprecatedOption("CMSIncrementalPacing", JavaVersionSupport.JDK_8, null, JavaVersionSupport.JDK_9), new DeprecatedOption("CMSIncrementalSafetyFactor", JavaVersionSupport.JDK_8, null, JavaVersionSupport.JDK_9), new DeprecatedOption("CMSIncrementalDutyCycle", JavaVersionSupport.JDK_8, null, JavaVersionSupport.JDK_9), new DeprecatedOption("CMSIncrementalDutyCycle", JavaVersionSupport.JDK_8, null, JavaVersionSupport.JDK_9), new DeprecatedOption("AdaptivePermSizeWeight", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9, Messages.getString("DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG")), new DeprecatedOption("CMSInitiatingPermOccupancyFraction", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9, Messages.getString("DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG")), new DeprecatedOption("CMSPermGenPrecleaningEnabled", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9, Messages.getString("DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG")), new DeprecatedOption("CMSRevisitStackSize", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9), new DeprecatedOption("CMSTriggerPermRatio", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9, Messages.getString("DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG")), new DeprecatedOption("MaxPermHeapExpansion", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9, Messages.getString("DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG")), new DeprecatedOption("MaxPermSize", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9, Messages.getString("DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG")), new DeprecatedOption("MinPermHeapExpansion", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9, Messages.getString("DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG")), new DeprecatedOption("PermGenPadding", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9, Messages.getString("DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG")), new DeprecatedOption("PermMarkSweepDeadRatio", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9, Messages.getString("DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG")), new DeprecatedOption("PermSize", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9, Messages.getString("DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG")), new DeprecatedOption("PrintRevisitStats", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9), new DeprecatedOption("UseISM", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9), new DeprecatedOption("UseMPSS", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9), new DeprecatedOption("UsePermISM", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9), new DeprecatedOption("UseSplitVerifier", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9), new DeprecatedOption("UseStringCache", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9), new DeprecatedOption("UseVectoredExceptions", null, JavaVersionSupport.JDK_8, JavaVersionSupport.JDK_9), new DeprecatedOption("CreateMinidumpOnCrash", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("UseParNewGC", JavaVersionSupport.JDK_9, null, null), new DeprecatedOption("CMSMarkStackSizeMax", JavaVersionSupport.JDK_9, null, null), new DeprecatedOption("CMSMarkStackSize", JavaVersionSupport.JDK_9, null, null), new DeprecatedOption("G1MarkStackSize", JavaVersionSupport.JDK_9, null, null), new DeprecatedOption("ParallelMarkingThreads", JavaVersionSupport.JDK_9, null, null), new DeprecatedOption("ParallelCMSThreads", JavaVersionSupport.JDK_9, null, null), new DeprecatedOption("AdaptiveSizePausePolicy", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("AutoShutdownNMT", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("BackEdgeThreshold", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("CodeCacheMinimumFreeSpace", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("DefaultThreadPriority", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("JNIDetachReleasesMonitors", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("LazyBootClassLoader", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("NmethodSweepCheckInterval", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("NmethodSweepFraction", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("NoYieldsInMicrolock", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("ParallelGCRetainPLAB", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("PreInflateSpin", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("ReflectionWrapResolutionErrors", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("SafepointPollOffset", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("StarvationMonitorInterval", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("ThreadSafetyMargin", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("UseAltSigs", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("UseBoundThreads", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("UseCompilerSafepoints", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("UseFastAccessorMethods", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("UseFastEmptyMethods", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("UseNewReflection", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("UseOldInlining", null, JavaVersionSupport.JDK_9, null), new DeprecatedOption("VerifyReflectionBytecodes", null, JavaVersionSupport.JDK_9, null)};
    private static final DeprecatedOption[] DEPRECATED_OPTIONS_X = new DeprecatedOption[]{new DeprecatedOption("incgc", JavaVersionSupport.JDK_8, null, JavaVersionSupport.JDK_9), new DeprecatedOption("run", JavaVersionSupport.JDK_8, null, JavaVersionSupport.JDK_9)};

    private static void checkOptions(String optionList, JavaVersion usedVersion, List<String> undocumentedList, List<OptionWarning> deprecatedList, List<OptionWarning> notRecommendedList) {
        String[] options;
        String[] stringArray = options = optionList.split(" ");
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            OptionsCheckRule.checkOption(option, usedVersion, undocumentedList, deprecatedList, notRecommendedList);
            ++n2;
        }
    }

    private static void checkOption(String option, JavaVersion usedVersion, List<String> undocumentedList, List<OptionWarning> deprecatedList, List<OptionWarning> notRecommendedList) {
        OptionsCheckRule.checkNotRecommended(option, usedVersion, notRecommendedList);
        Matcher m = XX_OPTION_PATTERN.matcher(option);
        if (m.matches()) {
            String optionName = m.group(1);
            if (OptionsCheckRule.checkDeprecatedXX(option, optionName, usedVersion, deprecatedList)) {
                return;
            }
            if (OptionsCheckRule.checkDocumentedXX(option, optionName, usedVersion, undocumentedList)) {
                return;
            }
        } else if (option.startsWith("-X") && OptionsCheckRule.checkDeprecatedX(option, usedVersion, deprecatedList)) {
            return;
        }
    }

    private static boolean checkDeprecatedXX(String option, String optionName, JavaVersion usedVersion, List<OptionWarning> deprecatedList) {
        if (usedVersion != null) {
            DeprecatedOption[] deprecatedOptionArray = DEPRECATED_OPTIONS_XX;
            int n = DEPRECATED_OPTIONS_XX.length;
            int n2 = 0;
            while (n2 < n) {
                DeprecatedOption deprecatedOption = deprecatedOptionArray[n2];
                if (deprecatedOption.getName().equals(optionName)) {
                    deprecatedList.add(new OptionWarning(option, deprecatedOption.getVersionText(), deprecatedOption.getScore(usedVersion)));
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean checkDeprecatedX(String option, JavaVersion usedVersion, List<OptionWarning> deprecatedList) {
        if (usedVersion != null) {
            DeprecatedOption[] deprecatedOptionArray = DEPRECATED_OPTIONS_X;
            int n = DEPRECATED_OPTIONS_X.length;
            int n2 = 0;
            while (n2 < n) {
                DeprecatedOption deprecatedOption = deprecatedOptionArray[n2];
                if (option.startsWith(deprecatedOption.getName(), 2)) {
                    deprecatedList.add(new OptionWarning(option, deprecatedOption.getVersionText(), deprecatedOption.getScore(usedVersion)));
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean checkDocumentedXX(String option, String optionName, JavaVersion usedVersion, List<String> undocumentedList) {
        String[] documentedOptions;
        if (JavaVersionSupport.JDK_7.isSameMajorVersion(usedVersion)) {
            documentedOptions = JAVA_7_DOCUMENTED_XX;
        } else if (JavaVersionSupport.JDK_8.isSameMajorVersion(usedVersion)) {
            documentedOptions = JAVA_8_DOCUMENTED_XX;
        } else {
            return false;
        }
        boolean isDocumented = false;
        String[] stringArray = documentedOptions;
        int n = documentedOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String documentedOption = stringArray[n2];
            if (documentedOption.equals(optionName)) {
                isDocumented = true;
            }
            ++n2;
        }
        if (!isDocumented) {
            undocumentedList.add(option);
            return true;
        }
        return false;
    }

    private static boolean checkNotRecommended(String option, JavaVersion usedVersion, List<OptionWarning> notRecommendedList) {
        return false;
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return OptionsCheckRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        String optionList = (String)items.getAggregate(JdkAggregators.JVM_ARGUMENTS);
        if (optionList != null) {
            int i;
            int score;
            JavaVersion usedVersion = RulesToolkit.getJavaVersion((IItemCollection)items);
            ArrayList<String> undocumentedList = new ArrayList<String>();
            ArrayList<OptionWarning> deprecatedList = new ArrayList<OptionWarning>();
            ArrayList<OptionWarning> notRecommendedList = new ArrayList<OptionWarning>();
            OptionsCheckRule.checkOptions(optionList, usedVersion, undocumentedList, deprecatedList, notRecommendedList);
            StringBuilder sb = new StringBuilder();
            boolean problemFound = false;
            int combinedScore = 0;
            if (undocumentedList.size() > 0) {
                sb.append(undocumentedList.size() == 1 ? Messages.getString("OptionsCheckRule_TEXT_OPTION_NOT_DOCUMENTED") : Messages.getString("OptionsCheckRule_TEXT_OPTIONS_NOT_DOCUMENTED"));
                sb.append(" ");
                sb.append(Messages.getString("OptionsCheckRule_TEXT_UNDOCUMENTED_WARNING"));
                sb.append("<ul>");
                int i2 = 0;
                while (i2 < undocumentedList.size()) {
                    sb.append("<li>\"" + Encode.forHtmlContent((String)undocumentedList.get(i2)) + "\"</li>");
                    ++i2;
                }
                sb.append("</ul>");
                problemFound = true;
                combinedScore = 50;
            }
            if (deprecatedList.size() > 0) {
                if (problemFound) {
                    sb.append("<p>");
                }
                sb.append(deprecatedList.size() == 1 ? Messages.getString("OptionsCheckRule_TEXT_OPTION_DEPRECATED") : Messages.getString("OptionsCheckRule_TEXT_OPTIONS_DEPRECATED"));
                sb.append(" ");
                sb.append(Messages.getString("OptionsCheckRule_TEXT_DEPRECATED_WARNING"));
                sb.append("<ul>");
                score = 0;
                i = 0;
                while (i < deprecatedList.size()) {
                    sb.append("<li>\"" + Encode.forHtmlContent(((OptionWarning)deprecatedList.get(i)).getOption()) + "\": " + ((OptionWarning)deprecatedList.get(i)).getWarning() + "</li>");
                    score = Math.max(score, ((OptionWarning)deprecatedList.get(i)).getScore());
                    ++i;
                }
                sb.append("</ul>");
                problemFound = true;
                combinedScore = Math.max(combinedScore, score);
            }
            if (notRecommendedList.size() > 0) {
                if (problemFound) {
                    sb.append("<p>");
                }
                sb.append(notRecommendedList.size() == 1 ? Messages.getString("OptionsCheckRule_TEXT_OPTION_NOT_RECOMMENDED") : Messages.getString("OptionsCheckRule_TEXT_OPTIONS_NOT_RECOMMENDED"));
                sb.append("<ul>");
                score = 0;
                i = 0;
                while (i < notRecommendedList.size()) {
                    sb.append("<li>\"" + Encode.forHtmlContent(((OptionWarning)notRecommendedList.get(i)).getOption()) + "\": " + ((OptionWarning)notRecommendedList.get(i)).getWarning() + "</li>");
                    score = Math.max(score, ((OptionWarning)deprecatedList.get(i)).getScore());
                    ++i;
                }
                sb.append("</ul>");
                problemFound = true;
                combinedScore = Math.max(combinedScore, score);
            }
            if (problemFound) {
                return new Result((IRule)this, (double)combinedScore, sb.toString());
            }
            return new Result((IRule)this, 0.0, Messages.getString("OptionsCheckRule_TEXT_OK"));
        }
        return RulesToolkit.getNotApplicableResult((IRule)this, (String)Messages.getString("OptionsCheckRule_TEXT_NA"));
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("OptionsCheckRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }

    private static class DeprecatedOption {
        private final String name;
        private final JavaVersion deprecatedIn;
        private final JavaVersion obsoleteIn;
        private final JavaVersion removedIn;
        private final String message;

        public DeprecatedOption(String name, JavaVersion deprecatedIn, JavaVersion obsoleteIn, JavaVersion removedIn) {
            this(name, deprecatedIn, obsoleteIn, removedIn, null);
        }

        public DeprecatedOption(String name, JavaVersion deprecatedIn, JavaVersion obsoleteIn, JavaVersion removedIn, String message) {
            this.name = name;
            this.deprecatedIn = deprecatedIn;
            this.obsoleteIn = obsoleteIn;
            this.removedIn = removedIn;
            this.message = message;
        }

        public String getName() {
            return this.name;
        }

        private String getDeprecationText() {
            if (this.deprecatedIn != null && this.obsoleteIn != null && this.removedIn != null) {
                return MessageFormat.format(Messages.getString("OptionsCheckRule_TEXT_DEPRECATED_IGNORED_REMOVED"), this.deprecatedIn.getMajorVersion(), this.obsoleteIn.getMajorVersion(), this.removedIn.getMajorVersion());
            }
            if (this.deprecatedIn != null && this.obsoleteIn != null) {
                return MessageFormat.format(Messages.getString("OptionsCheckRule_TEXT_DEPRECATED_IGNORED"), this.deprecatedIn.getMajorVersion(), this.obsoleteIn.getMajorVersion());
            }
            if (this.deprecatedIn != null && this.removedIn != null) {
                return MessageFormat.format(Messages.getString("OptionsCheckRule_TEXT_DEPRECATED_REMOVED"), this.deprecatedIn.getMajorVersion(), this.removedIn.getMajorVersion());
            }
            if (this.obsoleteIn != null && this.removedIn != null) {
                return MessageFormat.format(Messages.getString("OptionsCheckRule_TEXT_IGNORED_REMOVED"), this.obsoleteIn.getMajorVersion(), this.removedIn.getMajorVersion());
            }
            if (this.deprecatedIn != null) {
                return MessageFormat.format(Messages.getString("OptionsCheckRule_TEXT_DEPRECATED"), this.deprecatedIn.getMajorVersion());
            }
            if (this.obsoleteIn != null) {
                return MessageFormat.format(Messages.getString("OptionsCheckRule_TEXT_IGNORED"), this.obsoleteIn.getMajorVersion());
            }
            if (this.removedIn != null) {
                return MessageFormat.format(Messages.getString("OptionsCheckRule_TEXT_REMOVED"), this.removedIn.getMajorVersion());
            }
            return "";
        }

        public String getVersionText() {
            String versionText = this.getDeprecationText();
            if (this.message != null) {
                if (versionText.length() > 0) {
                    return String.valueOf(versionText) + " " + this.message;
                }
                return this.message;
            }
            return versionText;
        }

        private boolean isRemoved(JavaVersion usedVersion) {
            return this.removedIn != null && usedVersion.isGreaterOrEqualThan(this.removedIn);
        }

        private boolean isObsolete(JavaVersion usedVersion) {
            return this.obsoleteIn != null && usedVersion.isGreaterOrEqualThan(this.obsoleteIn);
        }

        private boolean isDeprecated(JavaVersion usedVersion) {
            return this.deprecatedIn != null && usedVersion.isGreaterOrEqualThan(this.deprecatedIn);
        }

        public int getScore(JavaVersion usedVersion) {
            if (this.isRemoved(usedVersion)) {
                return 100;
            }
            if (this.isObsolete(usedVersion)) {
                return 74;
            }
            if (this.isDeprecated(usedVersion)) {
                return 50;
            }
            if (this.obsoleteIn != null || this.deprecatedIn != null) {
                return 24;
            }
            return 0;
        }
    }

    private static class OptionWarning {
        private final String option;
        private final String warning;
        private final int score;

        public OptionWarning(String option, String warning, int score) {
            this.option = option;
            this.warning = warning;
            this.score = score;
        }

        public String getOption() {
            return this.option;
        }

        public String getWarning() {
            return this.warning;
        }

        public int getScore() {
            return this.score;
        }
    }
}

