/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.general;

import com.oracle.jmc.common.IMCThread;
import com.oracle.jmc.common.IPredicate;
import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.GroupingAggregator;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemConsumerFactory;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class FewSampledThreadsRule
implements IRule {
    private static final IAggregator<Iterable<? extends GroupingAggregator.GroupEntry<IMCThread, Aggregators.CountConsumer>>, ?> SAMPLES_PER_THREAD = GroupingAggregator.build((String)Messages.getString("FewSampledThreadsRule_AGGR_SAMPLES_PER_THREAD"), (String)Messages.getString("FewSampledThreadsRule_AGGR_SAMPLES_PER_THREAD_DESC"), (IAccessorFactory)JfrAttributes.EVENT_THREAD, (IItemConsumerFactory)Aggregators.count(), (IPredicate)new IPredicate<IType<IItem>>(){

        public boolean evaluate(IType<IItem> type) {
            return type.getIdentifier().equals("com.oracle.jdk.ExecutionSample");
        }
    });
    private static final String RESULT_ID = "FewSampledThreads";
    public static final TypedPreference<IQuantity> SAMPLED_THREADS_RATIO_LIMIT = new TypedPreference("sampled.threads.ratio.limit", Messages.getString("FewSampledThreadsRule_CONFIG_WARNING_LIMIT"), Messages.getString("FewSampledThreadsRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.25));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(SAMPLED_THREADS_RATIO_LIMIT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider vp) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return FewSampledThreadsRule.this.evaluate(items, ((IQuantity)vp.getPreferenceValue(SAMPLED_THREADS_RATIO_LIMIT)).doubleValueIn((IUnit)UnitLookup.NUMBER_UNITY));
            }
        });
        return evaluationTask;
    }

    private Result evaluate(IItemCollection items, double sampledThreadRatioLimit) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ActiveSetting", "com.oracle.jdk.ExecutionSample", "com.oracle.jdk.CPUInformation"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.ActiveSetting", "com.oracle.jdk.ExecutionSample", "com.oracle.jdk.CPUInformation"});
        }
        Iterable samplesPerThread = (Iterable)items.getAggregate(SAMPLES_PER_THREAD);
        int threadsWithEnoughSamples = 0;
        for (GroupingAggregator.GroupEntry ge : samplesPerThread) {
            if (((Aggregators.CountConsumer)ge.getConsumer()).getCount() <= 4) continue;
            ++threadsWithEnoughSamples;
        }
        IQuantity hwThreadsQ = (IQuantity)items.apply(ItemFilters.type((String)"com.oracle.jdk.CPUInformation")).getAggregate(Aggregators.max((IAttribute)JdkAttributes.HW_THREADS));
        if (hwThreadsQ == null) {
            return RulesToolkit.getTooFewEventsResult((IRule)this);
        }
        long hwThreads = hwThreadsQ.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        if ((long)threadsWithEnoughSamples >= hwThreads) {
            return new Result((IRule)this, 0.0, Messages.getString("FewSampledThreadsRule_TEXT_OK"));
        }
        double sampledThreadRatio = (double)threadsWithEnoughSamples / (double)hwThreads;
        double score = RulesToolkit.mapExp74((double)(1.0 - sampledThreadRatio), (double)sampledThreadRatioLimit);
        return new Result((IRule)this, score, Messages.getString("FewSampledThreadsRule_TEXT_INFO"), MessageFormat.format(Messages.getString("FewSampledThreadsRule_TEXT_INFO_LONG"), threadsWithEnoughSamples, hwThreads), JdkQueries.EXECUTION_SAMPLE);
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("FewSampledThreadsRule_RULE_NAME");
    }

    public String getTopic() {
        return "java_application";
    }
}

