/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.general;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.dataproviders.JvmInternalsDataProvider;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.owasp.encoder.Encode;

public class DuplicateFlagsRule
implements IRule {
    private static final String RESULT_ID = "DuplicateFlags";

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        Set<String> dupes;
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.JVMInformation"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.JVMInformation"});
        }
        IItemCollection jvmInfoItems = items.apply(JdkFilters.VM_INFO);
        Set args = (Set)jvmInfoItems.getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.JVM_ARGUMENTS));
        if (args != null && !args.isEmpty() && !(dupes = JvmInternalsDataProvider.checkDuplicates((String)args.iterator().next())).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<ul>");
            for (String dupe : dupes) {
                sb.append("<li>" + Encode.forHtml(dupe) + "</li>");
            }
            sb.append("</ul>");
            String shortDescription = dupes.size() > 1 ? MessageFormat.format(Messages.getString("DuplicateFlagsRuleFactory_TEXT_WARN"), dupes.size()) : Messages.getString("DuplicateFlagsRuleFactory_TEXT_WARN_SINGULAR");
            return new Result((IRule)this, 50.0, shortDescription, MessageFormat.format(Messages.getString("DuplicateFlagsRuleFactory_TEXT_WARN_LONG"), sb.toString()), JdkQueries.VM_INFO);
        }
        return new Result((IRule)this, 0.0, Messages.getString("DuplicateFlagsRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return DuplicateFlagsRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DuplicateFlagsRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

