/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.general;

import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class DiscouragedVmOptionsRule
implements IRule {
    private static final String DISCOURAGED_VM_OPTIONS_RESULT_ID = "DiscouragedVmOptions";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.BooleanFlag"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.BooleanFlag"});
        }
        Boolean unlockExperimentalVMOptions = (Boolean)items.getAggregate(JdkAggregators.UNLOCK_EXPERIMENTAL_VM_OPTIONS);
        Boolean ignoreUnrecognizedVMOptions = (Boolean)items.getAggregate(JdkAggregators.IGNORE_UNRECOGNIZED_VM_OPTIONS);
        if (unlockExperimentalVMOptions != null && ignoreUnrecognizedVMOptions != null && unlockExperimentalVMOptions.booleanValue() && ignoreUnrecognizedVMOptions.booleanValue()) {
            String shortMessage = String.valueOf(Messages.getString("UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO")) + " " + Messages.getString("IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO");
            String longMessage = String.valueOf(Messages.getString("UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO_LONG")) + " " + Messages.getString("IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO_LONG");
            return new Result((IRule)this, 50.0, shortMessage, longMessage);
        }
        if (ignoreUnrecognizedVMOptions != null && ignoreUnrecognizedVMOptions.booleanValue()) {
            return new Result((IRule)this, 50.0, Messages.getString("IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO"), Messages.getString("IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO_LONG"));
        }
        if (unlockExperimentalVMOptions != null && unlockExperimentalVMOptions.booleanValue()) {
            return new Result((IRule)this, 50.0, Messages.getString("UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO"), Messages.getString("UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO_LONG"));
        }
        return new Result((IRule)this, 0.0, Messages.getString("DiscouragedVmOptionsRule_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return DiscouragedVmOptionsRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return DISCOURAGED_VM_OPTIONS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DiscouragedVmOptionsRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

