/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.general;

import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.BinaryPrefix;
import com.oracle.jmc.common.unit.IPrefix;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.memory.CollectorType;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class DiscouragedGcOptionsRule
implements IRule {
    private static final IQuantity LARGE_HEAP = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.GIBI).quantity(4L);
    private static final IQuantity HW_THREADS_FOR_MULTI_CPU = UnitLookup.NUMBER_UNITY.quantity(4L);
    private static final IQuantity ONE = UnitLookup.NUMBER_UNITY.quantity(1L);
    private static final String GC_OPTIONS_RESULT_ID = "GcOptions";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.CPUInformation"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.CPUInformation"});
        }
        IQuantity parallelGCThreads = (IQuantity)items.getAggregate(JdkAggregators.PARALLEL_GC_THREAD_COUNT_MAX);
        IQuantity minHwThreads = (IQuantity)items.getAggregate(JdkAggregators.MIN_HW_THREADS);
        CollectorType oc = CollectorType.getOldCollectorType(items);
        if (parallelGCThreads != null && minHwThreads != null && oc != null) {
            if (oc == CollectorType.SERIAL_OLD) {
                IQuantity maxHeapSize = (IQuantity)items.getAggregate(JdkAggregators.HEAP_CONF_MAX_SIZE);
                if (minHwThreads.compareTo((Object)HW_THREADS_FOR_MULTI_CPU) >= 0 && maxHeapSize != null && maxHeapSize.compareTo((Object)LARGE_HEAP) > 0) {
                    return new Result((IRule)this, 50.0, Messages.getString("SerialGcOnMultiCpuRuleFactory_TEXT_INFO"), Messages.getString("SerialGcOnMultiCpuRuleFactory_TEXT_INFO_LONG"));
                }
            } else {
                if (minHwThreads.compareTo((Object)ONE) == 0 && oc == CollectorType.PARALLEL_OLD) {
                    return new Result((IRule)this, 50.0, Messages.getString("ParallelOnSingleCpuRuleFactory_TEXT_INFO"), Messages.getString("ParallelOnSingleCpuRuleFactory_TEXT_INFO_LONG"));
                }
                if (parallelGCThreads.compareTo((Object)minHwThreads) > 0) {
                    return new Result((IRule)this, 50.0, MessageFormat.format(Messages.getString("NumberOfGcThreadsRuleFactory_TEXT_INFO"), parallelGCThreads, minHwThreads.displayUsing("auto")), Messages.getString("NumberOfGcThreadsRuleFactory_TEXT_INFO_LONG"));
                }
                if (parallelGCThreads.compareTo((Object)ONE) == 0 && (oc == CollectorType.PARALLEL_OLD || oc == CollectorType.G1_OLD)) {
                    return new Result((IRule)this, 50.0, Messages.getString("ParGcFewThreadsRuleFactory_TEXT_INFO"), Messages.getString("ParGcFewThreadsRuleFactory_TEXT_INFO_LONG"));
                }
            }
            return new Result((IRule)this, 0.0, Messages.getString("DiscouragedGcOptionsRule_TEXT_OK"));
        }
        return RulesToolkit.getTooFewEventsResult((IRule)this);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return DiscouragedGcOptionsRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return GC_OPTIONS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DiscouragedGcOptionsRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

