/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.general;

import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.common.version.JavaVersion;
import com.oracle.jmc.common.version.JavaVersionSupport;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class DebugNonSafepointsRule
implements IRule {
    private static final String DEBUG_NON_SAFEPOINTS_RESULT_ID = "DebugNonSafepoints";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        boolean dnsEnabled = RulesToolkit.findMatches((String)"com.oracle.jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JVM_ARGUMENTS, (String)"\\-XX\\:\\+DebugNonSafepoints", (boolean)false) != null;
        boolean dnsDisabled = RulesToolkit.findMatches((String)"com.oracle.jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JVM_ARGUMENTS, (String)"\\-XX\\:\\-DebugNonSafepoints", (boolean)false) != null;
        JavaVersion javaVersion = RulesToolkit.getJavaSpecVersion((IItemCollection)items);
        if (javaVersion == null) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (String)Messages.getString("General_TEXT_COULD_NOT_DETERMINE_JAVA_VERSION"));
        }
        boolean implicitlyEnabled = javaVersion.isGreaterOrEqualThan(JavaVersionSupport.DEBUG_NON_SAFEPOINTS_IMPLICITLY_ENABLED);
        if (!implicitlyEnabled) {
            if (dnsDisabled) {
                return new Result((IRule)this, 25.0, Messages.getString("DebugNonSafepointsRule_DISABLED_TEXT_INFO"), Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_TEXT_INFO_LONG"));
            }
            if (!dnsEnabled) {
                return new Result((IRule)this, 50.0, Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_TEXT_INFO"), Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_TEXT_INFO_LONG"));
            }
            return new Result((IRule)this, 0.0, Messages.getString("DebugNonSafepointsRule_TEXT_OK"));
        }
        return new Result((IRule)this, 0.0, Messages.getString("DebugNonSafepointsRule_IMPLICIT_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return DebugNonSafepointsRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return DEBUG_NON_SAFEPOINTS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DebugNonSafepointsRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

