/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.general;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class ClassLoadingRule
implements IRule {
    private static final String RESULT_ID = "ClassLoading";
    public static final TypedPreference<IQuantity> MAX_DURATION_LIMIT = new TypedPreference("classloading.duration.max.limit", Messages.getString("ClassLoadingRule_CONFIG_DURATION_LIMIT"), Messages.getString("ClassLoadingRule_CONFIG_DURATION_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECONDS.quantity(1000L));
    public static final TypedPreference<IQuantity> RATIO_OF_TOTAL_LIMIT = new TypedPreference("classloading.ratio-to-total.limit", Messages.getString("ClassLoadingRule_CONFIG_RATIO_LIMIT"), Messages.getString("ClassLoadingRule_CONFIG_RATIO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.1));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(MAX_DURATION_LIMIT, RATIO_OF_TOTAL_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ClassLoad"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.ClassLoad"});
        }
        IQuantity maxDurationLimit = (IQuantity)valueProvider.getPreferenceValue(MAX_DURATION_LIMIT);
        IQuantity ratioOfTotalLimit = (IQuantity)valueProvider.getPreferenceValue(MAX_DURATION_LIMIT);
        IItemCollection events = items.apply(JdkFilters.CLASS_LOAD);
        IQuantity startTime = (IQuantity)events.getAggregate(JdkAggregators.FIRST_ITEM_START);
        IQuantity endTime = (IQuantity)events.getAggregate(JdkAggregators.LAST_ITEM_END);
        if (startTime != null && endTime != null) {
            IQuantity totalTime = endTime.subtract(startTime);
            IQuantity max = (IQuantity)events.getAggregate(Aggregators.max((IAttribute)JfrAttributes.DURATION));
            IQuantity sum = (IQuantity)events.getAggregate(Aggregators.sum((IAttribute)JfrAttributes.DURATION));
            if (max.compareTo((Object)maxDurationLimit) > 0 || sum.ratioTo(totalTime) > ratioOfTotalLimit.doubleValue()) {
                return new Result((IRule)this, 50.0, Messages.getString("ClassLoadingRuleFactory_TEXT_INFO"), Messages.getString("ClassLoadingRuleFactory_TEXT_INFO_LONG"), JdkQueries.CLASS_LOAD);
            }
        }
        return new Result((IRule)this, 0.0, Messages.getString("ClassLoadingRuleFactory_RULE_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return ClassLoadingRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ClassLoadingRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "classloading";
    }
}

