/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.exceptions;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.combine.SpanSquare;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class ExceptionRule
implements IRule {
    private static final String RESULT_ID = "Exceptions";
    public static final TypedPreference<IQuantity> EXCEPTIONS_WARNING_LIMIT = new TypedPreference("exception.warning.limit", Messages.getString("ExceptionRule_CONFIG_WARN_LIMIT"), Messages.getString("ExceptionRule_CONFIG_WARN_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(10000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(EXCEPTIONS_WARNING_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ExceptionStatistics"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.ExceptionStatistics"});
        }
        long warningLimit = ((IQuantity)vp.getPreferenceValue(EXCEPTIONS_WARNING_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        SpanSquare maxExceptionPeriod = ExceptionRule.calculateExPerSec(items.apply(JdkFilters.THROWABLES_STATISTICS));
        if (maxExceptionPeriod != null) {
            double duration = (double)(maxExceptionPeriod.end - maxExceptionPeriod.start) / 1.0E9;
            double exPerSec = (double)maxExceptionPeriod.mass / duration;
            long infoLimit = warningLimit / 2L;
            double score = RulesToolkit.mapExp100((double)exPerSec, (double)infoLimit, (double)warningLimit);
            String startTime = KindOfQuantity.format((Number)maxExceptionPeriod.start, (IUnit)UnitLookup.EPOCHNANOS);
            String durationStr = KindOfQuantity.format((Number)duration, (IUnit)UnitLookup.SECONDS);
            String exPerSecStr = KindOfQuantity.format((Number)exPerSec, (IUnit)UnitLookup.NUMBER_UNITY);
            String message = MessageFormat.format(Messages.getString("ExceptionRule_TEXT_MESSAGE"), durationStr, startTime, exPerSecStr);
            return new Result((IRule)this, score, message, score < 25.0 ? null : Messages.getString("ExceptionRule_TEXT_INFO_LONG"), JdkQueries.THROWABLES_STATISTICS);
        }
        return RulesToolkit.getTooFewEventsResult((IRule)this);
    }

    private static SpanSquare calculateExPerSec(IItemCollection items) {
        IItemIterable ii;
        Iterator itemIt;
        Iterator iiIterator = items.iterator();
        if (iiIterator.hasNext() && (itemIt = (ii = (IItemIterable)iiIterator.next()).iterator()).hasNext()) {
            IType type = ii.getType();
            IMemberAccessor throwables = JdkAttributes.EXCEPTION_THROWABLES_COUNT.getAccessor(type);
            IMemberAccessor timeAccessor = JfrAttributes.END_TIME.getAccessor(type);
            ArrayList<SpanSquare> periods = new ArrayList<SpanSquare>();
            IItem first = (IItem)itemIt.next();
            long lastCount = ((IQuantity)throwables.getMember((Object)first)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
            long lastTimestamp = ((IQuantity)timeAccessor.getMember((Object)first)).clampedLongValueIn((IUnit)UnitLookup.EPOCHNANOS);
            while (itemIt.hasNext()) {
                IItem item = (IItem)itemIt.next();
                long count = ((IQuantity)throwables.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
                long time = ((IQuantity)timeAccessor.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.EPOCHNANOS);
                periods.add(new SpanSquare(lastTimestamp, time, count - lastCount));
                lastCount = count;
                lastTimestamp = time;
            }
            return SpanSquare.getMax(periods.toArray(new SpanSquare[periods.size()]));
        }
        return null;
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return ExceptionRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ExceptionRule_RULE_NAME");
    }

    public String getTopic() {
        return "exceptions";
    }
}

