/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.exceptions;

import com.oracle.jmc.common.IMCType;
import com.oracle.jmc.common.collection.MapToolkit;
import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.QuantityRange;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.Pair;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.owasp.encoder.Encode;

public class ErrorRule
implements IRule {
    private static final String RESULT_ID = "Errors";
    public static final TypedPreference<IQuantity> ERROR_INFO_LIMIT = new TypedPreference("error.info.limit", Messages.getString("ErrorRule_CONFIG_INFO_LIMIT"), Messages.getString("ErrorRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(30L));
    public static final TypedPreference<IQuantity> ERROR_WARNING_LIMIT = new TypedPreference("error.warning.limit", Messages.getString("ErrorRule_CONFIG_WARN_LIMIT"), Messages.getString("ErrorRule_CONFIG_WARN_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(60L));
    public static final TypedPreference<String> EXCLUDED_ERRORS_REGEXP = new TypedPreference("error.exclude.regexp", Messages.getString("ErrorRule_CONFIG_EXCLUDED_ERRORS"), Messages.getString("ErrorRule_CONFIG_EXCLUDED_ERRORS_LONG"), UnitLookup.PLAIN_TEXT.getPersister(), (Object)"(com.sun.el.parser.ELParser\\$LookaheadSuccess)");
    public static final TypedPreference<IQuantity> ERROR_WINDOW_SIZE = new TypedPreference("error.window.size", Messages.getString("ErrorRule_CONFIG_WINDOW_SIZE"), Messages.getString("ErrorRule_CONFIG_WINDOW_SIZE_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECONDS.quantity(60L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(ERROR_INFO_LIMIT, ERROR_WARNING_LIMIT, EXCLUDED_ERRORS_REGEXP, ERROR_WINDOW_SIZE);
    private FutureTask<Result> evaluationTask;

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        IQuantity errorCount;
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.JavaErrorThrow"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.JavaErrorThrow"});
        }
        long warnLimit = ((IQuantity)vp.getPreferenceValue(ERROR_WARNING_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        long infoLimit = ((IQuantity)vp.getPreferenceValue(ERROR_INFO_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        String errorExcludeRegexp = ((String)vp.getPreferenceValue(EXCLUDED_ERRORS_REGEXP)).trim();
        IItemCollection errorItems = items;
        IQuantity excludedErrors = null;
        if (!errorExcludeRegexp.isEmpty()) {
            IItemFilter matchesExclude = ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.EXCEPTION_THROWNCLASS_NAME, (String)errorExcludeRegexp);
            IItemFilter errorsExcludingExclude = ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"com.oracle.jdk.JavaErrorThrow"), ItemFilters.not((IItemFilter)matchesExclude)});
            errorItems = errorItems.apply(errorsExcludingExclude);
            excludedErrors = (IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.count(), (IItemFilter)ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"com.oracle.jdk.JavaErrorThrow"), ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.EXCEPTION_THROWNCLASS_NAME, (String)errorExcludeRegexp)})));
        }
        if ((errorCount = (IQuantity)errorItems.getAggregate(JdkAggregators.ERROR_COUNT)) != null && errorCount.doubleValue() > 0.0) {
            final ArrayList errorsList = new ArrayList();
            IQuantity windowSize = (IQuantity)vp.getPreferenceValue(ERROR_WINDOW_SIZE);
            IQuantity slideSize = windowSize.getUnit().quantity(windowSize.ratioTo(windowSize.getUnit().quantity(2L)));
            RulesToolkit.slidingWindowUnordered((RulesToolkit.IUnorderedWindowVisitor)new RulesToolkit.IUnorderedWindowVisitor(){

                public void visitWindow(IItemCollection items, IQuantity startTime, IQuantity endTime) {
                    IRange timeRange = QuantityRange.createWithEnd((IQuantity)startTime, (IQuantity)endTime);
                    Double errors = ((IQuantity)items.getAggregate(Aggregators.count())).doubleValue();
                    if (errors > 0.0) {
                        ITypedQuantity errorsPerMinute = UnitLookup.NUMBER_UNITY.quantity(errors / ((IQuantity)timeRange.getExtent()).doubleValueIn((IUnit)UnitLookup.MINUTES));
                        errorsList.add(new Pair((Object)errorsPerMinute, (Object)timeRange));
                    }
                }

                public boolean shouldContinue() {
                    return !ErrorRule.this.evaluationTask.isCancelled();
                }
            }, (IItemCollection)errorItems, (IQuantity)windowSize, (IQuantity)slideSize);
            Pair<IQuantity, IRange<IQuantity>> maxErrorsPerMinute = Collections.max(errorsList, new Comparator<Pair<IQuantity, IRange<IQuantity>>>(){

                @Override
                public int compare(Pair<IQuantity, IRange<IQuantity>> o1, Pair<IQuantity, IRange<IQuantity>> o2) {
                    return ((IQuantity)o1.left).compareTo((Object)((IQuantity)o2.left));
                }
            });
            List errorGrouping = RulesToolkit.calculateGroupingScore((IItemCollection)errorItems, (IAccessorFactory)JdkAttributes.EXCEPTION_THROWNCLASS);
            String mostCommonError = Encode.forHtml(((IMCType)((MapToolkit.IntEntry)errorGrouping.get((int)(errorGrouping.size() - 1))).key).getFullName());
            int errorsThrown = ((MapToolkit.IntEntry)errorGrouping.get(errorGrouping.size() - 1)).getValue();
            double score = RulesToolkit.mapExp100((double)((IQuantity)maxErrorsPerMinute.left).doubleValue(), (double)infoLimit, (double)warnLimit);
            String longMessage = MessageFormat.format(Messages.getString("ErrorRule_TEXT_WARN_LONG"), mostCommonError, errorsThrown);
            if (excludedErrors != null && excludedErrors.longValue() > 0L) {
                longMessage = String.valueOf(longMessage) + " " + MessageFormat.format(Messages.getString("ErrorRule_TEXT_WARN_EXCLUDED_INFO"), errorExcludeRegexp, excludedErrors);
            }
            return new Result((IRule)this, score, MessageFormat.format(Messages.getString("ErrorRule_TEXT_WARN"), ((IQuantity)maxErrorsPerMinute.left).displayUsing("auto"), ((IRange)maxErrorsPerMinute.right).displayUsing("auto"), errorCount), longMessage, JdkQueries.ERRORS);
        }
        return new Result((IRule)this, 0.0, Messages.getString("ErrorRule_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        this.evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return ErrorRule.this.getResult(items, valueProvider);
            }
        });
        return this.evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ErrorRule_RULE_NAME");
    }

    public String getTopic() {
        return "exceptions";
    }
}

