/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.dataproviders;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemConsumer;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.rules.jdk.combine.Combinable;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;

public class ObjectStatisticsDataProvider {
    public static IAggregator<IQuantity, ?> getIncreaseAggregator() {
        return new Aggregators.MergingAggregator<IQuantity, IncreaseCalculator>(Messages.getString("ObjectStatisticsDataProvider_AGGR_LIVE_SIZE_INCREASE"), Messages.getString("ObjectStatisticsDataProvider_AGGR_LIVE_SIZE_INCREASE_DESC"), (IType)UnitLookup.MEMORY){

            public boolean acceptType(IType<IItem> type) {
                return "com.oracle.jdk.ObjectCount".equals(type.getIdentifier());
            }

            public IncreaseCalculator newItemConsumer(IType<IItem> type) {
                IType<IItem> iType = type;
                return new IncreaseCalculator((IMemberAccessor<IQuantity, IItem>)JfrAttributes.END_TIME.getAccessor(iType), (IMemberAccessor<IQuantity, IItem>)JdkAttributes.HEAP_TOTAL.getAccessor(iType));
            }

            public IQuantity getValue(IncreaseCalculator consumer) {
                return consumer == null || consumer.maxX == null ? null : consumer.yAtMaxX.subtract(consumer.yAtMinX);
            }
        };
    }

    private static class IncreaseCalculator
    implements IItemConsumer<IncreaseCalculator>,
    Combinable<IncreaseCalculator> {
        private final IMemberAccessor<IQuantity, IItem> xAccessor;
        private final IMemberAccessor<IQuantity, IItem> yAccessor;
        private IQuantity minX;
        private IQuantity yAtMinX;
        private IQuantity maxX;
        private IQuantity yAtMaxX;

        IncreaseCalculator(IMemberAccessor<IQuantity, IItem> xAccessor, IMemberAccessor<IQuantity, IItem> yAccessor) {
            this.xAccessor = xAccessor;
            this.yAccessor = yAccessor;
        }

        public void consume(IItem item) {
            this.add((IQuantity)this.xAccessor.getMember((Object)item), (IQuantity)this.yAccessor.getMember((Object)item));
        }

        private void add(IQuantity x, IQuantity y) {
            if (x != null && y != null) {
                if (this.minX == null) {
                    this.minX = this.maxX = x;
                    this.yAtMinX = this.yAtMaxX = y;
                } else if (x.compareTo((Object)this.minX) < 0) {
                    this.minX = x;
                    this.yAtMinX = y;
                } else if (x.compareTo((Object)this.maxX) > 0) {
                    this.maxX = x;
                    this.yAtMaxX = y;
                }
            }
        }

        public IncreaseCalculator merge(IncreaseCalculator other) {
            this.combineWith(other);
            return this;
        }

        @Override
        public IncreaseCalculator combineWith(IncreaseCalculator other) {
            this.add(other.minX, other.yAtMinX);
            this.add(other.maxX, other.yAtMaxX);
            return this;
        }
    }
}

