/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.dataproviders;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.common.IMCMethod;
import com.oracle.jmc.common.IMCStackTrace;
import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.GroupingAggregator;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import java.util.List;

public class MethodProfilingDataProvider {
    public static final IItemFilter SAMPLES_OR_CPU_FILTER = ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.EXECUTION_SAMPLE, JdkFilters.CPU_LOAD});
    public static final IAggregator<IQuantity, ?> MIN_ENDTIME = Aggregators.min((String)Messages.getString("MethodProfilingDataProvider_AGGR_MIN_ENDTIME"), null, (String)"com.oracle.jdk.CPULoad", (IAttribute)JfrAttributes.END_TIME);
    public static final IAggregator<IQuantity, ?> MAX_ENDTIME = Aggregators.max((String)Messages.getString("MethodProfilingDataProvider_AGGR_MAX_ENDTIME"), null, (String)"com.oracle.jdk.CPULoad", (IAttribute)JfrAttributes.END_TIME);
    public static final IAccessorFactory<IMCMethod> TOP_FRAME_ACCESSOR_FACTORY = new IAccessorFactory<IMCMethod>(){

        public <T> IMemberAccessor<IMCMethod, T> getAccessor(IType<T> type) {
            final IMemberAccessor sta = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return new IMemberAccessor<IMCMethod, T>(){

                public IMCMethod getMember(T inObject) {
                    IMCStackTrace st = (IMCStackTrace)sta.getMember(inObject);
                    if (st != null && !st.getFrames().isEmpty()) {
                        return ((IMCFrame)st.getFrames().get(0)).getMethod();
                    }
                    return null;
                }
            };
        }
    };
    public static final GroupingAggregator.IQuantityListFinisher<IQuantity> topFrameBalanceFunction = new GroupingAggregator.IQuantityListFinisher<IQuantity>(){

        public IType<IQuantity> getValueType() {
            return UnitLookup.NUMBER;
        }

        public IQuantity getValue(List<IQuantity> values, IQuantity total) {
            if (total != null && total.doubleValue() > 0.0) {
                IUnit totalUnit = total.getUnit();
                double totalValue = total.doubleValue();
                double score = 0.0;
                int i = values.size() - 1;
                while (i >= 0) {
                    int index = values.size() - i;
                    score += values.get(i).doubleValueIn(totalUnit) / (double)index;
                    --i;
                }
                return UnitLookup.NUMBER_UNITY.quantity(score / totalValue);
            }
            return null;
        }
    };
    public static final GroupingAggregator.IQuantityListFinisher<IQuantity> topFrameQuotaFunction = new GroupingAggregator.IQuantityListFinisher<IQuantity>(){

        public IType<IQuantity> getValueType() {
            return UnitLookup.NUMBER;
        }

        public IQuantity getValue(List<IQuantity> values, IQuantity total) {
            if (total != null && total.doubleValue() > 0.0) {
                double score = values.get(values.size() - 1).ratioTo(total);
                return UnitLookup.NUMBER_UNITY.quantity(score);
            }
            return null;
        }
    };
    public static final IAggregator<IQuantity, ?> TOP_FRAME_BALANCE = GroupingAggregator.build((String)Messages.getString("MethodProfilingDataProvider_AGGR_TOP_FRAME_BALANCE"), (String)Messages.getString("MethodProfilingDataProvider_AGGR_TOP_FRAME_BALANCE_DESC"), TOP_FRAME_ACCESSOR_FACTORY, (IAggregator)JdkAggregators.EXECUTION_SAMPLE_COUNT, topFrameBalanceFunction);
    public static final IAggregator<IQuantity, ?> TOP_FRAME_QUOTA = GroupingAggregator.build((String)Messages.getString("MethodProfilingDataProvider_AGGR_AGGR_TOP_FRAME_QUOTA"), (String)Messages.getString("MethodProfilingDataProvider_AGGR_AGGR_TOP_FRAME_QUOTA_DESC"), TOP_FRAME_ACCESSOR_FACTORY, (IAggregator)JdkAggregators.EXECUTION_SAMPLE_COUNT, topFrameQuotaFunction);
}

