/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.dataproviders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JvmInternalsDataProvider {
    private static final String[] PREFIXES = new String[]{"Xmx", "Xms", "Xmn", "Xss", "Xmaxjitcodesize"};
    private static final String[] VERBATIM = new String[]{"verbose"};
    private static final Map<String, String> EQUIVALENT = new HashMap<String, String>();

    static {
        JvmInternalsDataProvider.putBiMap("Xbatch", "BackgroundCompilation");
        JvmInternalsDataProvider.putBiMap("Xmaxjitcodesize", "ReservedCodeCacheSize");
        JvmInternalsDataProvider.putBiMap("Xmx", "MaxHeapSize");
        JvmInternalsDataProvider.putBiMap("Xmn", "NewSize");
        JvmInternalsDataProvider.putBiMap("Xss", "ThreadStackSize");
        JvmInternalsDataProvider.putBiMap("Xusealtsigs", "UseAltSigs");
        JvmInternalsDataProvider.putBiMap("cp", "classpath");
        JvmInternalsDataProvider.putBiMap("esa", "enablesystemassertions");
        JvmInternalsDataProvider.putBiMap("dsa", "disablesystemassertions");
        JvmInternalsDataProvider.putBiMap("Xconcgc", "UseConcMarkSweepGC");
        JvmInternalsDataProvider.putBiMap("Xnoconcgc", "UseConcMarkSweepGC");
        JvmInternalsDataProvider.putBiMap("Xnoclassgc", "ClassUnloading");
        JvmInternalsDataProvider.putBiMap("Xminf", "MinHeapFreeRatio");
        JvmInternalsDataProvider.putBiMap("Xmaxf", "MaxHeapFreeRatio");
        JvmInternalsDataProvider.putBiMap("Xrs", "ReduceSignalUsage");
        JvmInternalsDataProvider.putBiMap("Dcom.sun.management", "ManagementServer");
        JvmInternalsDataProvider.putBiMap("Xshare:dump", "DumpSharedSpaces");
        JvmInternalsDataProvider.putBiMap("Xboundthreads", "UseBoundThreads");
        JvmInternalsDataProvider.putBiMap("AlwaysTenure", "NeverTenure");
        JvmInternalsDataProvider.putBiMap("ResizeTLE", "ResizeTLAB");
        JvmInternalsDataProvider.putBiMap("PrintTLE", "PrintTLAB");
        JvmInternalsDataProvider.putBiMap("TLESize", "TLABSize");
        JvmInternalsDataProvider.putBiMap("UseTLE", "UseTLAB");
        JvmInternalsDataProvider.putBiMap("UsePermISM", "UseISM");
        JvmInternalsDataProvider.putBiMap("G1MarkStackSize", "CMSMarkStackSize");
        JvmInternalsDataProvider.putBiMap("Xms", "InitialHeapSize");
        JvmInternalsDataProvider.putBiMap("DisplayVMOutputToStderr", "DisplayVMOutputToStdout");
        JvmInternalsDataProvider.putBiMap("Xverify", "BytecodeVerificationLocal");
        JvmInternalsDataProvider.putBiMap("Xverify", "BytecodeVerificationRemote");
        JvmInternalsDataProvider.putBiMap("DefaultMaxRAMFraction", "MaxRAMFraction");
        JvmInternalsDataProvider.putBiMap("CMSMarkStackSizeMax", "MarkStackSizeMax");
        JvmInternalsDataProvider.putBiMap("ParallelMarkingThreads", "ConcGCThreads");
        JvmInternalsDataProvider.putBiMap("ParallelCMSThreads", "ConcGCThreads");
        JvmInternalsDataProvider.putBiMap("CreateMinidumpOnCrash", "CreateCoredumpOnCrash");
    }

    private static void putBiMap(String one, String two) {
        EQUIVALENT.put(one, two);
        EQUIVALENT.put(two, one);
    }

    public static Set<String> checkDuplicates(String arguments) {
        HashSet<String> seenFlags = new HashSet<String>();
        HashSet<String> dupes = new HashSet<String>();
        String[] argumentArray = arguments.split(" -");
        if (argumentArray.length == 1 && argumentArray[0].equals("")) {
            return dupes;
        }
        argumentArray[0] = argumentArray[0].substring(1);
        String[] stringArray = argumentArray;
        int n = argumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            String argument;
            String fullArgument = stringArray[n2];
            boolean verbatim = false;
            int i = 0;
            while (i < VERBATIM.length) {
                if (fullArgument.contains(VERBATIM[i])) {
                    verbatim = true;
                    break;
                }
                ++i;
            }
            if (verbatim) {
                argument = fullArgument;
            } else {
                String[] split = fullArgument.split("[=:]", 3);
                argument = split[0];
                if ("XX".equals(split[0]) && ((argument = split[1]).startsWith("+") || argument.startsWith("-"))) {
                    argument = argument.substring(1);
                }
                int i2 = 0;
                while (i2 < PREFIXES.length) {
                    argument = JvmInternalsDataProvider.scrubPrefix(argument, PREFIXES[i2]);
                    ++i2;
                }
                String equivalentArgument = EQUIVALENT.get(argument);
                if (equivalentArgument != null && !seenFlags.contains(argument) && seenFlags.contains(equivalentArgument)) {
                    String longerArgument = equivalentArgument.length() > argument.length() ? equivalentArgument : argument;
                    String shorterArgument = equivalentArgument.length() > argument.length() ? argument : equivalentArgument;
                    String combinedArgument = String.format("%s (%s)", longerArgument, shorterArgument);
                    dupes.add(combinedArgument);
                }
            }
            if (seenFlags.contains(argument)) {
                dupes.add(argument);
            }
            seenFlags.add(argument);
            ++n2;
        }
        return dupes;
    }

    private static String scrubPrefix(String argument, String prefix) {
        return argument.startsWith(prefix) ? prefix : argument;
    }
}

