/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.cpu;

import com.oracle.jmc.common.collection.MapToolkit;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class ManyRunningProcessesRule
implements IRule {
    private static final String MANY_RUNNING_PROCESSES_RESULT_ID = "ManyRunningProcesses";
    public static final TypedPreference<IQuantity> OTHER_PROCESSES_INFO_LIMIT = new TypedPreference("other.processes.info.limit", Messages.getString("ManyRunningProcessesRule_INFO_LIMIT"), Messages.getString("ManyRunningProcessesRule_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(150L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(OTHER_PROCESSES_INFO_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.SystemProcess"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.SystemProcess"});
        }
        List entries = RulesToolkit.calculateGroupingScore((IItemCollection)items.apply(JdkFilters.PROCESSES), (IAccessorFactory)JfrAttributes.END_TIME);
        MapToolkit.IntEntry maxNumberProcesses = (MapToolkit.IntEntry)entries.get(entries.size() - 1);
        double score = RulesToolkit.mapExp100((double)maxNumberProcesses.getValue(), (double)((IQuantity)vp.getPreferenceValue(OTHER_PROCESSES_INFO_LIMIT)).clampedFloorIn((IUnit)UnitLookup.NUMBER_UNITY));
        String text = MessageFormat.format(Messages.getString("ManyRunningProcessesRule_TEXT_INFO"), maxNumberProcesses.getValue(), ((IQuantity)maxNumberProcesses.key).displayUsing("auto"));
        return new Result((IRule)this, score, text, Messages.getString("ManyRunningProcessesRule_TEXT_INFO_LONG"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return ManyRunningProcessesRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return MANY_RUNNING_PROCESSES_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ManyRunningProcessesRule_RULE_NAME");
    }

    public String getTopic() {
        return "processes";
    }
}

