/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.cpu;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class HighJvmCpuRule
implements IRule {
    private static final int MAX_SAMPLED_THREADS = 5;
    private static final String RESULT_ID = "HighJvmCpu";
    public static final TypedPreference<IQuantity> MISSING_SAMPLE_LIMIT = new TypedPreference("missing.sample.limit", Messages.getString("HighJvmCpuRule_CONFIG_SAMPLE_LIMIT"), Messages.getString("HighJvmCpuRule_CONFIG_SAMPLE_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.5));
    public static final TypedPreference<IQuantity> MINIMUM_CPU_LOAD_PERIOD = new TypedPreference("minimum.cpu.period", Messages.getString("HighJvmCpuRule_CONFIG_MIN_CPULOAD"), Messages.getString("HighJvmCpuRule_CONFIG_MIN_CPU_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECONDS.quantity(10L));
    public static final TypedPreference<IQuantity> JVM_CPU_INFO_LIMIT = new TypedPreference("jvm.cpu.info.limit", Messages.getString("HighJvmCpuRule_CONFIG_CPU_INFO_LIMIT"), Messages.getString("HighJvmCpuRule_CONFIG_CPU_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(80L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(JVM_CPU_INFO_LIMIT, MINIMUM_CPU_LOAD_PERIOD, MISSING_SAMPLE_LIMIT);
    private static final IAggregator<IQuantity, ?> MAX_ENDTIME = Aggregators.max((String)Messages.getString("HighJvmCpuRule_AGGR_MAX_ENDTIME"), null, (String)"com.oracle.jdk.CPULoad", (IAttribute)JfrAttributes.END_TIME);
    private static final IAggregator<IQuantity, ?> MIN_ENDTIME = Aggregators.min((String)Messages.getString("HighJvmCpuRule_AGGR_MIN_ENDTIME"), null, (String)"com.oracle.jdk.CPULoad", (IAttribute)JfrAttributes.END_TIME);

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.CPULoad"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.CPULoad"});
        }
        String periodNotBelow = RulesToolkit.getPeriodNotBelow((IItemCollection)items, (IQuantity)((IQuantity)vp.getPreferenceValue(MINIMUM_CPU_LOAD_PERIOD)), (String[])new String[]{"com.oracle.jdk.CPULoad"});
        if (periodNotBelow != null) {
            return new Result((IRule)this, 50.0, Messages.getString("HighJvmCpuRule_LONG_CPU_LOAD_PERIOD"), MessageFormat.format(Messages.getString("HighJvmCpuRule_LONG_CPU_LOAD_PERIOD_LONG"), periodNotBelow));
        }
        IItemCollection cpuItems = items.apply(JdkFilters.CPU_LOAD);
        IType cpuLoadType = RulesToolkit.getType((IItemCollection)cpuItems, (String)"com.oracle.jdk.CPULoad");
        if (!cpuLoadType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.JVM_USER)) {
            return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)cpuLoadType, (IAttribute)JdkAttributes.JVM_USER);
        }
        IQuantity jvmUsage = (IQuantity)cpuItems.getAggregate(JdkAggregators.AVG_JVM_USER_CPU);
        IQuantity profilingSamples = (IQuantity)items.getAggregate(JdkAggregators.EXECUTION_SAMPLE_COUNT);
        IQuantity maxPeriodProfiling = RulesToolkit.getSettingMaxPeriod((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ExecutionSample"});
        if (profilingSamples != null && profilingSamples.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY) > 0L && maxPeriodProfiling != null) {
            double missingSampleLimit;
            double jvmVal;
            double maximumSamplesPerSecond = UnitLookup.SECONDS.quantity(1L).ratioTo(maxPeriodProfiling) * 5.0;
            IQuantity first = (IQuantity)cpuItems.getAggregate(MIN_ENDTIME);
            IQuantity last = (IQuantity)cpuItems.getAggregate(MAX_ENDTIME);
            double lengthInSeconds = last == null ? 0.0 : last.subtract(first).doubleValueIn((IUnit)UnitLookup.SECONDS);
            double samples = profilingSamples.doubleValue();
            double samplesPerSecond = samples / lengthInSeconds;
            double lackingSamplesRatio = 1.0 - samplesPerSecond / maximumSamplesPerSecond;
            double lackingSamplesTimesCpu = lackingSamplesRatio * (jvmVal = jvmUsage.doubleValue());
            if (lackingSamplesTimesCpu >= (missingSampleLimit = ((IQuantity)vp.getPreferenceValue(MISSING_SAMPLE_LIMIT)).doubleValue())) {
                double missingSamplesScore = RulesToolkit.mapExp74((double)lackingSamplesTimesCpu, (double)missingSampleLimit);
                return new Result((IRule)this, missingSamplesScore, Messages.getString("HighJvmCpuRule_FEW_SAMPLES"), Messages.getString("HighJvmCpuRule_FEW_SAMPLES_LONG"));
            }
        }
        long infoLimit = ((IQuantity)vp.getPreferenceValue(JVM_CPU_INFO_LIMIT)).longValue();
        double jvmUsageScore = RulesToolkit.mapExp74((double)jvmUsage.doubleValueIn((IUnit)UnitLookup.PERCENT), (double)infoLimit);
        if (jvmUsageScore >= (double)infoLimit) {
            return new Result((IRule)this, jvmUsageScore, Messages.getString("HighJvmCpuRule_TEXT_WARN"));
        }
        return new Result((IRule)this, jvmUsageScore, Messages.getString("HighJvmCpuRule_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return HighJvmCpuRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HighJvmCpuRule_RULE_NAME");
    }

    public String getTopic() {
        return "java_application";
    }
}

