/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.cpu;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.combine.SpanLimit;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class CompareCpuRule
implements IRule {
    private static final String COMPARE_CPU_RESULT_ID = "CompareCpu";
    public static final TypedPreference<IQuantity> OTHER_CPU_WARNING_LIMIT = new TypedPreference("other.cpu.warning.limit", Messages.getString("CompareCpuRule_WARNING_LIMIT"), Messages.getString("CompareCpuRule_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(40L));
    public static final TypedPreference<IQuantity> OTHER_CPU_INFO_LIMIT = new TypedPreference("other.cpu.info.limit", Messages.getString("CompareCpuRule_INFO_LIMIT"), Messages.getString("CompareCpuRule_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(20L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(OTHER_CPU_INFO_LIMIT, OTHER_CPU_WARNING_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        double score;
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.CPULoad"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.CPULoad"});
        }
        long warningLimit = ((IQuantity)vp.getPreferenceValue(OTHER_CPU_WARNING_LIMIT)).clampedFloorIn((IUnit)UnitLookup.NUMBER_UNITY);
        IItemCollection cpuItems = items.apply(JdkFilters.CPU_LOAD);
        IType cpuLoadType = RulesToolkit.getType((IItemCollection)cpuItems, (String)"com.oracle.jdk.CPULoad");
        if (!cpuLoadType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.JVM_TOTAL)) {
            return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)cpuLoadType, (IAttribute)JdkAttributes.JVM_TOTAL);
        }
        SpanLimit max = CompareCpuRule.calculateSpanMax(cpuItems, warningLimit);
        if (max == null) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (String)Messages.getString("CompareCpuRule_TEXT_TOO_FEW_SAMPLES"));
        }
        long otherCpuMaxValue = max.value;
        String startTime = KindOfQuantity.format((Number)max.start, (IUnit)UnitLookup.EPOCHNANOS);
        String duration = KindOfQuantity.format((Number)(max.end - max.start), (IUnit)UnitLookup.NANOSECONDS);
        String otherCpuMaxValueString = UnitLookup.PERCENT.quantity(otherCpuMaxValue).displayUsing("auto");
        String message = MessageFormat.format(Messages.getString("CompareCpuRule_TEXT_MESSAGE"), duration, startTime, otherCpuMaxValueString);
        return new Result((IRule)this, score, message, (score = RulesToolkit.mapExp100((double)otherCpuMaxValue, (double)((IQuantity)vp.getPreferenceValue(OTHER_CPU_INFO_LIMIT)).clampedFloorIn((IUnit)UnitLookup.NUMBER_UNITY), (double)warningLimit)) < 25.0 ? null : Messages.getString("CompareCpuRule_TEXT_INFO_LONG"), null);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return CompareCpuRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return COMPARE_CPU_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("CompareCpuRule_RULE_NAME");
    }

    public String getTopic() {
        return "processes";
    }

    private static IMemberAccessor<IQuantity, IItem> getJvmOtherAccessor(IType<IItem> cpuSampleType) {
        final IMemberAccessor jvmTotalAccessor = JdkAttributes.JVM_TOTAL.getAccessor(cpuSampleType);
        final IMemberAccessor machineTotalAccessor = JdkAttributes.MACHINE_TOTAL.getAccessor(cpuSampleType);
        return new IMemberAccessor<IQuantity, IItem>(){

            public IQuantity getMember(IItem i) {
                IQuantity machineTotal = (IQuantity)machineTotalAccessor.getMember((Object)i);
                IQuantity jvmTotal = (IQuantity)jvmTotalAccessor.getMember((Object)i);
                return machineTotal != null && jvmTotal != null ? machineTotal.subtract(jvmTotal) : null;
            }
        };
    }

    private static SpanLimit calculateSpanMax(IItemCollection allCpuItems, long warningLimit) {
        SpanLimit max = null;
        ArrayList<SpanLimit> periods = new ArrayList<SpanLimit>();
        boolean first = true;
        long lastCount = 0L;
        long lastTimestamp = 0L;
        Iterator cpuItemsIterator = allCpuItems.iterator();
        if (cpuItemsIterator.hasNext()) {
            IItemIterable cpuItems = (IItemIterable)cpuItemsIterator.next();
            Iterator cpuIter = cpuItems.iterator();
            IMemberAccessor<IQuantity, IItem> jvmOtherAccessor = CompareCpuRule.getJvmOtherAccessor((IType<IItem>)cpuItems.getType());
            IMemberAccessor endTimeAccessor = JfrAttributes.END_TIME.getAccessor(cpuItems.getType());
            while (cpuIter.hasNext()) {
                IItem item = (IItem)cpuIter.next();
                IQuantity otherCpu = (IQuantity)jvmOtherAccessor.getMember((Object)item);
                if (otherCpu == null) continue;
                long count = (long)(otherCpu.doubleValueIn((IUnit)UnitLookup.PERCENT_UNITY) * 100.0);
                long time = ((IQuantity)endTimeAccessor.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.EPOCHNANOS);
                if (first) {
                    lastCount = count;
                    lastTimestamp = time;
                    first = false;
                    continue;
                }
                periods.add(new SpanLimit(lastTimestamp, time, (count + lastCount) / 2L, warningLimit));
                lastCount = count;
                lastTimestamp = time;
            }
            if (periods.size() > 0) {
                max = SpanLimit.getMaxSpan(periods.toArray(new SpanLimit[0]));
            }
        }
        return max;
    }
}

