/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.compilation;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.StringToolkit;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.common.version.JavaVersion;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class CodeCacheRule
implements IRule {
    public static final String CODE_CACHE_RESULT_ID = "CodeCache";
    private static final String NON_PROFILED_NAME = "CodeHeap 'non-profiled nmethods'";
    private static final String PROFILED_NAME = "CodeHeap 'profiled nmethods'";
    private static final String NON_NMETHODS_NAME = "CodeHeap 'non-nmethods'";
    public static final TypedPreference<IQuantity> CODE_CACHE_SIZE_INFO_PERCENT = new TypedPreference("codeCache.size.info.limit", Messages.getString("CodeCacheRuleFactory_SIZE_INFO_LIMIT"), Messages.getString("CodeCacheRuleFactory_SIZE_INFO_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(50L));
    public static final TypedPreference<IQuantity> CODE_CACHE_SIZE_WARN_PERCENT = new TypedPreference("codeCache.size.warn.limit", Messages.getString("CodeCacheRuleFactory_SIZE_WARN_LIMIT"), Messages.getString("CodeCacheRuleFactory_SIZE_WARN_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(80L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(CODE_CACHE_SIZE_INFO_PERCENT, CODE_CACHE_SIZE_WARN_PERCENT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return CodeCacheRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.CodeCacheFull", "com.oracle.jdk.JVMInformation", "com.oracle.jdk.CodeCacheStatistics", "com.oracle.jdk.CodeCacheConfiguration"});
        if (eventAvailability != RulesToolkit.EventAvailability.ENABLED && eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.CodeCacheFull", "com.oracle.jdk.JVMInformation", "com.oracle.jdk.CodeCacheStatistics", "com.oracle.jdk.CodeCacheConfiguration"});
        }
        eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.CodeCacheConfiguration"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.CodeCacheConfiguration"});
        }
        IItemCollection ccItems = items.apply(JdkFilters.CODE_CACHE_CONFIGURATION);
        IType ccType = RulesToolkit.getType((IItemCollection)ccItems, (String)"com.oracle.jdk.CodeCacheConfiguration");
        IQuantity ccFullCount = (IQuantity)items.getAggregate(JdkAggregators.CODE_CACHE_FULL_COUNT);
        if (ccFullCount != null && ccFullCount.doubleValue() > 0.0) {
            return new Result((IRule)this, 100.0, Messages.getString("CodeCacheRuleFactory_TEXT_WARN"), Messages.getString("CodeCacheRuleFactory_TEXT_WARN_LONG"), JdkQueries.CODE_CACHE_FULL);
        }
        IQuantity infoPreferenceValue = (IQuantity)valueProvider.getPreferenceValue(CODE_CACHE_SIZE_INFO_PERCENT);
        IQuantity warningPreferenceValue = (IQuantity)valueProvider.getPreferenceValue(CODE_CACHE_SIZE_WARN_PERCENT);
        double allocationRatioScore = 0.0;
        String shortDescription = null;
        String longDescription = null;
        if (this.hasSegmentedCodeCache(items)) {
            IQuantity worstRatio;
            if (!ccType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.PROFILED_SIZE)) {
                return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)ccType, (IAttribute)JdkAttributes.PROFILED_SIZE);
            }
            IQuantity profiledAggregate = (IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.min((IAttribute)JdkAttributes.UNALLOCATED), (IItemFilter)ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.CODE_HEAP, (String)PROFILED_NAME)));
            ITypedQuantity profiledRatio = null;
            profiledRatio = profiledAggregate != null ? UnitLookup.PERCENT_UNITY.quantity(profiledAggregate.ratioTo((IQuantity)items.getAggregate(Aggregators.min((IAttribute)JdkAttributes.PROFILED_SIZE)))) : UnitLookup.PERCENT_UNITY.quantity(1.0);
            IQuantity nonProfiledAggregate = (IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.min((IAttribute)JdkAttributes.UNALLOCATED), (IItemFilter)ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.CODE_HEAP, (String)NON_PROFILED_NAME)));
            ITypedQuantity nonProfiledRatio = null;
            nonProfiledRatio = nonProfiledAggregate != null ? UnitLookup.PERCENT_UNITY.quantity(nonProfiledAggregate.ratioTo((IQuantity)items.getAggregate(Aggregators.min((IAttribute)JdkAttributes.NON_PROFILED_SIZE)))) : UnitLookup.PERCENT_UNITY.quantity(1.0);
            ITypedQuantity nonNMethodsRatio = UnitLookup.PERCENT_UNITY.quantity(((IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.min((IAttribute)JdkAttributes.UNALLOCATED), (IItemFilter)ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.CODE_HEAP, (String)NON_NMETHODS_NAME)))).ratioTo((IQuantity)items.getAggregate(Aggregators.min((IAttribute)JdkAttributes.NON_NMETHOD_SIZE))));
            ArrayList<CodeHeapData> heaps = new ArrayList<CodeHeapData>();
            this.addIfHalfFull((IQuantity)profiledRatio, heaps, PROFILED_NAME);
            this.addIfHalfFull((IQuantity)nonProfiledRatio, heaps, NON_PROFILED_NAME);
            this.addIfHalfFull((IQuantity)nonNMethodsRatio, heaps, NON_NMETHODS_NAME);
            Collections.sort(heaps);
            if (heaps.size() > 0) {
                shortDescription = heaps.size() > 1 ? MessageFormat.format(Messages.getString("CodeCacheRuleFactory_WARN_SEGMENTED_HEAPS_SHORT_DESCRIPTION"), StringToolkit.join(heaps, (String)",")) : MessageFormat.format(Messages.getString("CodeCacheRuleFactory_WARN_SEGMENTED_HEAP_SHORT_DESCRIPTION"), heaps.get(0));
                longDescription = String.valueOf(Messages.getString("CodeCacheRuleFactory_WARN_LONG_DESCRIPTION")) + Messages.getString("CodeCacheRuleFactory_DEFAULT_LONG_DESCRIPTION");
                worstRatio = ((CodeHeapData)heaps.get(0)).getRatio();
            } else {
                List<IQuantity> ratios = Arrays.asList(profiledRatio, nonProfiledRatio, nonNMethodsRatio);
                Collections.sort(ratios);
                worstRatio = ratios.get(0);
            }
            allocationRatioScore = RulesToolkit.mapExp100((double)(100.0 - worstRatio.doubleValueIn((IUnit)UnitLookup.PERCENT)), (double)infoPreferenceValue.doubleValueIn((IUnit)UnitLookup.PERCENT), (double)warningPreferenceValue.doubleValueIn((IUnit)UnitLookup.PERCENT));
        } else {
            if (!ccType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.RESERVED_SIZE)) {
                return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)ccType, (IAttribute)JdkAttributes.RESERVED_SIZE);
            }
            IQuantity codeCacheReserved = (IQuantity)items.getAggregate(Aggregators.min((String)"com.oracle.jdk.CodeCacheConfiguration", (IAttribute)JdkAttributes.RESERVED_SIZE));
            IQuantity unallocated = (IQuantity)items.getAggregate(Aggregators.min((String)"com.oracle.jdk.CodeCacheStatistics", (IAttribute)JdkAttributes.UNALLOCATED));
            ITypedQuantity unallocatedCodeCachePercent = UnitLookup.PERCENT_UNITY.quantity(unallocated.ratioTo(codeCacheReserved));
            allocationRatioScore = RulesToolkit.mapExp100((double)(100.0 - unallocatedCodeCachePercent.doubleValueIn((IUnit)UnitLookup.PERCENT)), (double)infoPreferenceValue.doubleValueIn((IUnit)UnitLookup.PERCENT), (double)warningPreferenceValue.doubleValueIn((IUnit)UnitLookup.PERCENT));
            shortDescription = MessageFormat.format(Messages.getString("CodeCacheRuleFactory_JDK8_TEXT_WARN"), unallocatedCodeCachePercent.displayUsing("auto"));
            longDescription = Messages.getString("CodeCacheRuleFactory_DEFAULT_LONG_DESCRIPTION");
        }
        if (allocationRatioScore >= 25.0) {
            return new Result((IRule)this, allocationRatioScore, shortDescription, longDescription);
        }
        return new Result((IRule)this, allocationRatioScore, Messages.getString("CodeCacheRuleFactory_TEXT_OK"));
    }

    private boolean hasSegmentedCodeCache(IItemCollection items) {
        JavaVersion version = RulesToolkit.getJavaVersion((IItemCollection)items);
        if (version != null && version.getMajorVersion() >= 9) {
            return (Boolean)items.apply(ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (String)"SegmentedCodeCache")).getAggregate(Aggregators.and((String)"com.oracle.jdk.BooleanFlag", (IAttribute)JdkAttributes.FLAG_VALUE_BOOLEAN));
        }
        return false;
    }

    private void addIfHalfFull(IQuantity ratioUnallocated, List<CodeHeapData> heaps, String name) {
        if (ratioUnallocated.compareTo((Object)UnitLookup.PERCENT_UNITY.quantity(0.5)) < 0) {
            heaps.add(new CodeHeapData(name, ratioUnallocated));
        }
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return CODE_CACHE_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("CodeCacheRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "code_cache";
    }

    private static class CodeHeapData
    implements Comparable<CodeHeapData> {
        private String name;
        private IQuantity ratio;

        CodeHeapData(String name, IQuantity ratio) {
            this.name = name;
            this.ratio = ratio;
        }

        IQuantity getRatio() {
            return this.ratio;
        }

        public String toString() {
            return String.valueOf(this.name) + "(" + this.ratio.displayUsing("auto") + ")";
        }

        @Override
        public int compareTo(CodeHeapData o) {
            return this.ratio.compareTo((Object)o.getRatio());
        }

        public int hashCode() {
            return this.name.hashCode() << this.ratio.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof CodeHeapData) {
                CodeHeapData other = (CodeHeapData)o;
                return this.ratio.compareTo((Object)other.ratio) == 0 && this.name.equals(other.name);
            }
            return false;
        }
    }
}

