/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.combine;

import com.oracle.jmc.flightrecorder.rules.jdk.combine.Combinable;
import com.oracle.jmc.flightrecorder.rules.jdk.combine.Combiner;

public class SpanLimit
implements Combinable<SpanLimit> {
    public final long start;
    public final long end;
    public final long value;
    public final long limit;

    public SpanLimit(long start, long end, long mass, long limit) {
        this.start = start;
        this.end = end;
        this.value = mass;
        this.limit = limit;
    }

    @Override
    public SpanLimit combineWith(SpanLimit other) {
        long combinedMass = (this.value + other.value) / 2L;
        return combinedMass > this.limit ? new SpanLimit(this.start, other.end, combinedMass, this.limit) : null;
    }

    public static SpanLimit getMaxSpan(SpanLimit ... clusters) {
        SpanLimit maxSpan = null;
        int clusterCount = Combiner.combine((Combinable[])clusters);
        int j = 0;
        while (j < clusterCount) {
            if (maxSpan == null || maxSpan.end - maxSpan.start < clusters[j].end - clusters[j].start) {
                maxSpan = clusters[j];
            }
            ++j;
        }
        return maxSpan;
    }

    public static SpanLimit getMaxValue(SpanLimit ... clusters) {
        SpanLimit maxValue = null;
        int clusterCount = Combiner.combine((Combinable[])clusters);
        int j = 0;
        while (j < clusterCount) {
            if (maxValue == null || maxValue.value < clusters[j].value) {
                maxValue = clusters[j];
            }
            ++j;
        }
        return maxValue;
    }
}

