/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rcp.application.scripting;

import com.oracle.jmc.commands.Command;
import com.oracle.jmc.commands.CommandsPlugin;
import com.oracle.jmc.commands.ICommandHelper;
import com.oracle.jmc.commands.Parameter;
import com.oracle.jmc.commands.Tokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class ProposalProvider
implements IContentProposalProvider {
    public IContentProposal[] getProposals(String contents, int position) {
        List<IContentProposal> props = this.getProposals(contents);
        Collections.sort(props, new ContentProposalComparator());
        return (IContentProposal[])props.toArray(new ContentProposal[props.size()]);
    }

    private List<IContentProposal> getProposals(String contents) {
        Tokenizer tokenizer = new Tokenizer(contents);
        if (tokenizer.getTokenCount() > 0 && (tokenizer.getText().endsWith(" ") || tokenizer.getTokenCount() > 1)) {
            return this.createParameterProposals(tokenizer.next().getText(), Math.max(tokenizer.getTokenCount() - 2, 0));
        }
        return this.createCommandProposals(tokenizer.hasNext() ? tokenizer.next().getText() : "");
    }

    private List<IContentProposal> createParameterProposals(String commandName, int parameterIndex) {
        Command c = CommandsPlugin.getDefault().getCommand(commandName);
        if (c != null && parameterIndex < c.getParameters().size()) {
            ICommandHelper ch = c.getCommandHelp();
            Parameter parameter = (Parameter)c.getParameters().get(parameterIndex);
            if (ch != null) {
                return this.createCommandHelperProposal(ch, parameter);
            }
        }
        return new ArrayList<IContentProposal>();
    }

    private List<IContentProposal> createCommandHelperProposal(ICommandHelper ch, Parameter parameter) {
        List texts = ch.getParameterSuggestions(parameter.getIdentifier());
        ArrayList<IContentProposal> list = new ArrayList<IContentProposal>();
        for (String text : texts) {
            list.add((IContentProposal)new ContentProposal(text));
        }
        return list;
    }

    private List<IContentProposal> createCommandProposals(String commandNameStart) {
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>();
        for (Command command : CommandsPlugin.getDefault().getCommands()) {
            if (!command.getIdentifier().startsWith(commandNameStart)) continue;
            proposals.add((IContentProposal)this.createCommandProposal(command));
        }
        return proposals;
    }

    private ContentProposal createCommandProposal(Command command) {
        String content = command.getIdentifier();
        StringBuilder labelBuilder = new StringBuilder(command.getName());
        labelBuilder.append(" -  ");
        labelBuilder.append(command.getIdentifier());
        for (Parameter p : command.getParameters()) {
            labelBuilder.append(' ');
            labelBuilder.append(p.getIdentifier());
        }
        StringBuilder descriptionBuilder = new StringBuilder(command.getDesciption());
        descriptionBuilder.append('\n');
        descriptionBuilder.append('\n');
        for (Parameter p : command.getParameters()) {
            descriptionBuilder.append(p.getIdentifier());
            descriptionBuilder.append(" - ");
            descriptionBuilder.append(p.getDescription());
            descriptionBuilder.append('\n');
        }
        descriptionBuilder.append('\n');
        return new ContentProposal(content, labelBuilder.toString(), descriptionBuilder.toString());
    }

    static class ContentProposalComparator
    implements Comparator<IContentProposal> {
        ContentProposalComparator() {
        }

        @Override
        public int compare(IContentProposal a, IContentProposal b) {
            return a.getLabel().compareTo(b.getLabel());
        }
    }
}

