/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rcp.application.p2;

import com.oracle.jmc.rcp.application.p2.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.CodeSigner;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public final class SignerValidator {
    private static final String ID_CE_keyUsage = "2.5.29.15";
    private static final String ID_CE_extKeyUsage = "2.5.29.37";
    private static final String ID_KP_codeSigning = "1.3.6.1.5.5.7.3.3";
    private static final String ID_KP_timeStamping = "1.3.6.1.5.5.7.3.8";
    private static final File CACERTS_PATH = SignerValidator.createCACertsPath();
    private final KeyStore keyStore;
    private final CertPathValidator chainValidator;
    private final X509CertSelector usSelector;

    public static SignerValidator getValidator() {
        return new SignerValidator();
    }

    private static File createCACertsPath() {
        String path = System.getProperty("com.oracle.jmc.p2.trustStore");
        if (path == null) {
            String sep = File.separator;
            path = String.valueOf(System.getProperty("java.home")) + sep + "lib" + sep + "security" + sep + "cacerts";
        }
        return new File(path);
    }

    public SignerValidator() {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (FileInputStream certs = new FileInputStream(CACERTS_PATH);){
                this.chainValidator = CertPathValidator.getInstance("PKIX");
                this.keyStore = KeyStore.getInstance("JKS");
                this.keyStore.load(certs, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SecurityException(e);
        }
        try {
            this.usSelector = new X509CertSelector();
            this.usSelector.setKeyUsage(new boolean[]{true});
            this.usSelector.setExtendedKeyUsage(Collections.singleton(ID_KP_codeSigning));
            this.usSelector.setSubject(new byte[]{48, -127, -106, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 19, 48, 17, 6, 3, 85, 4, 8, 19, 10, 67, 97, 108, 105, 102, 111, 114, 110, 105, 97, 49, 21, 48, 19, 6, 3, 85, 4, 7, 19, 12, 82, 101, 100, 119, 111, 111, 100, 32, 67, 105, 116, 121, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 79, 114, 97, 99, 108, 101, 32, 65, 109, 101, 114, 105, 99, 97, 44, 32, 73, 110, 99, 46, 49, 29, 48, 27, 6, 3, 85, 4, 11, 19, 20, 83, 111, 102, 116, 119, 97, 114, 101, 32, 69, 110, 103, 105, 110, 101, 101, 114, 105, 110, 103, 49, 29, 48, 27, 6, 3, 85, 4, 3, 19, 20, 79, 114, 97, 99, 108, 101, 32, 65, 109, 101, 114, 105, 99, 97, 44, 32, 73, 110, 99, 46});
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    public void validateSigner(CodeSigner signer) {
        CertPath certPath = signer.getSignerCertPath();
        if (!this.isUs(certPath.getCertificates().get(0))) {
            throw new SecurityException(Messages.DISTRUSTED_SIGNER);
        }
        try {
            PKIXBuilderParameters params = new PKIXBuilderParameters(this.keyStore, (CertSelector)new X509CertSelector());
            params.setRevocationEnabled(false);
            Timestamp timestamp = signer.getTimestamp();
            if (timestamp != null) {
                Date signTime = timestamp.getTimestamp();
                CertPath timeCertPath = timestamp.getSignerCertPath();
                if (!this.isTimeStamping(timeCertPath.getCertificates().get(0))) {
                    throw new SecurityException(Messages.DISTRUSTED_SIGNER);
                }
                this.chainValidator.validate(timeCertPath, params);
                params.setDate(signTime);
            }
            this.chainValidator.validate(certPath, params);
        }
        catch (InvalidAlgorithmParameterException | KeyStoreException e) {
            throw new SecurityException(e);
        }
        catch (CertPathValidatorException e) {
            throw new SecurityException(e);
        }
    }

    private boolean isUs(Certificate cert) {
        if (cert instanceof X509Certificate && this.usSelector.match(cert)) {
            X509Certificate x5cert = (X509Certificate)cert;
            boolean[] keyUsage = x5cert.getKeyUsage();
            if (keyUsage == null || keyUsage.length < 1 || !keyUsage[0]) {
                return false;
            }
            int i = 1;
            while (i < keyUsage.length) {
                if (keyUsage[i]) {
                    return false;
                }
                ++i;
            }
            Set<String> exts = x5cert.getCriticalExtensionOIDs();
            if (!exts.contains(ID_CE_keyUsage)) {
                return false;
            }
            return !x5cert.hasUnsupportedCriticalExtension();
        }
        return false;
    }

    private boolean isTimeStamping(Certificate cert) {
        if (cert instanceof X509Certificate) {
            List<String> extUses;
            X509Certificate x5cert = (X509Certificate)cert;
            Set<String> exts = x5cert.getCriticalExtensionOIDs();
            try {
                extUses = x5cert.getExtendedKeyUsage();
            }
            catch (CertificateParsingException e) {
                extUses = null;
            }
            if (exts == null || extUses == null) {
                return false;
            }
            return exts.contains(ID_CE_extKeyUsage) && extUses.contains(ID_KP_timeStamping) && !x5cert.hasUnsupportedCriticalExtension();
        }
        return false;
    }
}

