/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rcp.application.p2;

import com.oracle.jmc.rcp.application.ApplicationPlugin;
import com.oracle.jmc.rcp.application.p2.SignedRepositorySupport;
import com.oracle.jmc.rcp.application.p2.UpdateSiteURLToolkit;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.repository.helpers.LocationProperties;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;

public final class JMCDataManager
extends ArtifactRepositoryManager {
    private static final String ALLOWED_SUFFIX = "artifacts.jar";

    public JMCDataManager(IProvisioningAgent agent) {
        super(agent);
    }

    protected String getBundleId() {
        return "com.oracle.jmc.rcp.application";
    }

    protected String getDefaultSuffix() {
        return ALLOWED_SUFFIX;
    }

    protected String[] getPreferredRepositorySearchOrder(LocationProperties properties) {
        return new String[]{ALLOWED_SUFFIX};
    }

    protected String[] getAllSuffixes() {
        return new String[]{ALLOWED_SUFFIX};
    }

    protected Transport getTransport() {
        return new SignedRepositorySupport.DummyTransport();
    }

    protected void restoreSpecialRepositories() {
        for (String site : UpdateSiteURLToolkit.getUpdateSites()) {
            try {
                this.addRepository(new URI(site));
            }
            catch (URISyntaxException e) {
                ApplicationPlugin.getLogger().log(Level.WARNING, "Failed to add update site due to malformed URI.", e);
            }
        }
    }

    public static class Factory
    implements IAgentServiceFactory {
        public Object createService(IProvisioningAgent agent) {
            return new JMCDataManager(agent);
        }
    }
}

