/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rcp.application;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.core.CorePlugin;
import com.oracle.jmc.core.MCFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;

class BasicFile
implements MCFile {
    private final String path;

    BasicFile(String file) {
        this.path = file;
    }

    public String toString() {
        return this.path;
    }

    public void writeStream(InputStream stream, IProgressMonitor monitor, boolean append) throws IOException {
        File f = BasicFile.makeAbsolute(this.path);
        BasicFile.write(stream, f, append);
    }

    public boolean tryWriteStream(InputStream stream, IProgressMonitor monitor) throws IOException {
        File f = BasicFile.makeAbsolute(this.path);
        if (f.exists()) {
            return false;
        }
        BasicFile.write(stream, f, false);
        return true;
    }

    private static void write(InputStream in, File toOutput, boolean append) throws IOException {
        File parent = toOutput.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException();
        }
        IOToolkit.write((InputStream)in, (File)toOutput, (boolean)false);
    }

    public String getPath() {
        return this.path;
    }

    public static File makeAbsolute(String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(CorePlugin.getDefault().getWorkspaceDirectory(), path);
    }
}

