/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.util;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.IPredicate;
import com.oracle.jmc.common.collection.EntryHashMap;
import com.oracle.jmc.common.collection.IteratorToolkit;
import com.oracle.jmc.common.collection.MapToolkit;
import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.item.ItemToolkit;
import com.oracle.jmc.common.unit.BinaryPrefix;
import com.oracle.jmc.common.unit.IPrefix;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.LinearUnit;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.LabeledIdentifier;
import com.oracle.jmc.common.util.PredicateToolkit;
import com.oracle.jmc.common.util.StringToolkit;
import com.oracle.jmc.common.version.JavaVersion;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.messages.internal.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RulesToolkit {
    private static final String REC_SETTING_NAME_ENABLED = "enabled";
    private static final String REC_SETTING_NAME_THRESHOLD = "threshold";
    public static final String REC_SETTING_NAME_PERIOD = "period";
    public static final String REC_SETTING_PERIOD_EVERY_CHUNK = "everyChunk";
    private static final IAccessorFactory<String> TYPE_NAME_ACCESSOR_FACTORY = new IAccessorFactory<String>(){

        public <T> IMemberAccessor<String, T> getAccessor(IType<T> type) {
            final IMemberAccessor ta = JdkAttributes.REC_SETTING_FOR.getAccessor(type);
            return new IMemberAccessor<String, T>(){

                public String getMember(T inObject) {
                    LabeledIdentifier eventType = (LabeledIdentifier)ta.getMember(inObject);
                    return eventType == null ? null : eventType.getName();
                }
            };
        }
    };
    private static final LinearUnit MEBIBYTES = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.MEBI);
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*?JRE \\((\\d+(?:\\.\\d+(?:\\.\\d+(?:[\\._]\\d+)?)?)?(?:-ea)?).*");

    public static double leastSquareMemory(Iterator<? extends IItem> items, IMemberAccessor<IQuantity, IItem> timeField, IMemberAccessor<IQuantity, IItem> memField) {
        double sumX = 0.0;
        double sumY = 0.0;
        double sumX2 = 0.0;
        double sumXY = 0.0;
        double num = 0.0;
        double startTime = 0.0;
        while (items.hasNext()) {
            IItem item = items.next();
            long time = ((IQuantity)timeField.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.EPOCHSECONDS);
            long mem = ((IQuantity)memField.getMember((Object)item)).clampedLongValueIn((IUnit)MEBIBYTES);
            if (num == 0.0) {
                startTime = time;
            }
            time = (long)((double)time - startTime);
            sumX += (double)time;
            sumY += (double)mem;
            sumX2 += (double)(time * time);
            sumXY += (double)(time * mem);
            num += 1.0;
        }
        double value = (num * sumXY - sumX * sumY) / (num * sumX2 - sumX * sumX);
        return Double.isNaN(value) ? 0.0 : value;
    }

    public static String findMatches(String typeId, IItemCollection items, IAttribute<String> attribute, String match, boolean ignoreCase) {
        String regexp = ".*(" + (ignoreCase ? "?i:" : "") + match + ").*";
        return (String)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.distinctAsString((String)typeId, attribute), (IItemFilter)ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)typeId), ItemFilters.matches(attribute, (String)regexp)})));
    }

    public static <T> T getValue(IItem item, IAccessorFactory<T> attribute) {
        IType itemType = ItemToolkit.getItemType((IItem)item);
        IMemberAccessor accessor = attribute.getAccessor(itemType);
        if (accessor == null) {
            throw new IllegalArgumentException("The accessor factory could not build accessor for type " + itemType.getIdentifier() + ". This is likely due to an old unsupported recording where an attribute has changed name.");
        }
        return (T)accessor.getMember((Object)item);
    }

    public static IItemFilter getSettingsFilter(String settingsName, String ... typeIds) {
        final HashSet<String> types = new HashSet<String>(Arrays.asList(typeIds));
        IItemFilter typeFilter = new IItemFilter(){

            public IPredicate<IItem> getPredicate(IType<IItem> type) {
                final IMemberAccessor ma = JdkAttributes.REC_SETTING_FOR.getAccessor(type);
                if (ma != null) {
                    return new IPredicate<IItem>(){

                        public boolean evaluate(IItem o) {
                            LabeledIdentifier eventType = (LabeledIdentifier)ma.getMember((Object)o);
                            return eventType != null && types.contains(eventType.getInterfaceId());
                        }
                    };
                }
                return PredicateToolkit.falsePredicate();
            }
        };
        return ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.RECORDING_SETTING, typeFilter, ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.REC_SETTING_NAME, (Object)settingsName)});
    }

    public static IQuantity getSettingMaxPeriod(IItemCollection items, String ... typeIds) {
        Set<String> values = RulesToolkit.getPeriodSettings(items, typeIds);
        return values == null || values.isEmpty() ? null : RulesToolkit.getSettingMaxPeriod(values);
    }

    public static String getPeriodNotBelow(IItemCollection items, IQuantity minCpuPeriod, String ... typeIds) {
        Set<String> values = RulesToolkit.getPeriodSettings(items, typeIds);
        if (values != null && !values.isEmpty()) {
            IQuantity max = RulesToolkit.getSettingMaxPeriod(values);
            if (max == null) {
                return Messages.getString("RulesToolkit_EVERY_CHUNK");
            }
            if (max.compareTo((Object)minCpuPeriod) > 0) {
                return max.displayUsing("auto");
            }
        }
        return null;
    }

    public static IQuantity parsePersistedJvmTimespan(String persistedValue) throws QuantityConversionException {
        if (persistedValue.endsWith("m")) {
            persistedValue = String.valueOf(persistedValue) + "in";
        }
        return UnitLookup.TIMESPAN.parsePersisted(persistedValue);
    }

    public static String getTypesWithZeroThreshold(IItemCollection items, String ... typeIds) {
        IItemFilter f = new IItemFilter(){

            public IPredicate<IItem> getPredicate(IType<IItem> type) {
                final IMemberAccessor accessor = JdkAttributes.REC_SETTING_VALUE.getAccessor(type);
                return new IPredicate<IItem>(){

                    public boolean evaluate(IItem o) {
                        try {
                            String thresholdValue = (String)accessor.getMember((Object)o);
                            return RulesToolkit.parsePersistedJvmTimespan(thresholdValue).longValue() == 0L;
                        }
                        catch (QuantityConversionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
        IItemFilter filter = ItemFilters.and((IItemFilter[])new IItemFilter[]{RulesToolkit.getSettingsFilter(REC_SETTING_NAME_THRESHOLD, typeIds), f});
        return RulesToolkit.getEventTypeNames(items.apply(filter));
    }

    public static boolean isEventsEnabled(IItemCollection items, String ... typeIds) {
        IQuantity aggregate = (IQuantity)items.apply(RulesToolkit.createEnablementFilter(true, typeIds)).getAggregate(Aggregators.count());
        return aggregate != null && aggregate.longValue() == (long)typeIds.length;
    }

    public static boolean isEventsDisabled(IItemCollection items, String ... typeIds) {
        IQuantity aggregate = (IQuantity)items.apply(RulesToolkit.createEnablementFilter(false, typeIds)).getAggregate(Aggregators.count());
        return aggregate != null && aggregate.longValue() == (long)typeIds.length;
    }

    public static EventAvailability getEventAvailability(IItemCollection items, String ... typeIds) {
        if (RulesToolkit.hasEvents(items, typeIds)) {
            return EventAvailability.AVAILABLE;
        }
        if (RulesToolkit.isEventsEnabled(items, typeIds)) {
            return EventAvailability.ENABLED;
        }
        if (RulesToolkit.isEventsDisabled(items, typeIds)) {
            return EventAvailability.DISABLED;
        }
        if (RulesToolkit.isEventsKnown(items, typeIds)) {
            return EventAvailability.NONE;
        }
        return EventAvailability.UNAVAILABLE;
    }

    public static boolean isEventsKnown(IItemCollection items, String ... typeIds) {
        Set<String> availableTypes = RulesToolkit.getAvailableTypeIds(items);
        return availableTypes.containsAll(Arrays.asList(typeIds));
    }

    public static boolean hasEvents(IItemCollection items, String ... typeIds) {
        String[] stringArray = typeIds;
        int n = typeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String typeId = stringArray[n2];
            if (!RulesToolkit.internalHasEvents(items, typeId)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Result getEventAvailabilityResult(IRule rule, IItemCollection items, EventAvailability eventAvailability, String ... typeIds) {
        switch (eventAvailability) {
            case ENABLED: 
            case NONE: {
                return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_EVENTS"), rule.getName(), StringToolkit.join((Object[])typeIds, (String)", ")));
            }
            case DISABLED: {
                return RulesToolkit.getRequiresEnabledEventTypesResult(rule, items, typeIds);
            }
            case UNAVAILABLE: {
                return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_EVENT_TYPE"), rule.getName(), StringToolkit.join((Object[])typeIds, (String)", ")));
            }
        }
        return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_EVENT_TYPE_NOT_AVAILABLE"), rule.getName(), StringToolkit.join((Object[])typeIds, (String)", ")));
    }

    public static Result getTooFewEventsResult(IRule rule) {
        return RulesToolkit.getNotApplicableResult(rule, Messages.getString("RulesToolkit_TOO_FEW_EVENTS"));
    }

    public static Result getNotApplicableResult(IRule rule, String message) {
        return new Result(rule, -1.0, message);
    }

    public static JavaVersion getJavaSpecVersion(IItemCollection items) {
        IItemCollection versionProperties = items.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.SYSTEM_PROPERTIES, ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.ENVIRONMENT_KEY, (Object)"java.vm.specification.version")}));
        Set vmSpecificationVersions = (Set)versionProperties.getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.ENVIRONMENT_VALUE));
        if (vmSpecificationVersions != null && vmSpecificationVersions.size() >= 1) {
            return new JavaVersion((String)vmSpecificationVersions.iterator().next());
        }
        JavaVersion jvmVersion = RulesToolkit.getJavaVersion(items);
        if (jvmVersion != null) {
            return new JavaVersion(new int[]{jvmVersion.getMajorVersion()});
        }
        return null;
    }

    public static JavaVersion getJavaVersion(IItemCollection items) {
        String jvmVersion = (String)items.getAggregate(JdkAggregators.JVM_VERSION);
        return RulesToolkit.getJavaVersion(jvmVersion);
    }

    public static double mapExp74(double value, double x1) {
        return RulesToolkit.mapExp(value, 74.0, x1, 25.0);
    }

    public static double mapExp100(double value, double x1) {
        return RulesToolkit.mapExp(value, 100.0, x1, 75.0);
    }

    public static double mapExp100Y(double value, double x1, double y1) {
        return RulesToolkit.mapExp(value, 100.0, x1, y1);
    }

    public static double mapExp100(double value, double x1, double x2) {
        return RulesToolkit.mapExp(value, 100.0, x1, 25.0, x2, 75.0);
    }

    public static double mapExp(double value, double ceiling, double x1, double y1) {
        if (value < 0.0) {
            return 0.0;
        }
        double k = Math.log(1.0 - y1 / ceiling) / x1;
        return ceiling * (1.0 - Math.exp(k * value));
    }

    public static double mapExp(double value, double ceiling, double x1, double y1, double x2, double y2) {
        if (value < 0.0) {
            return 0.0;
        }
        if (value < x1) {
            return y1 / x1 * value;
        }
        return y1 + RulesToolkit.mapExp(value - x1, ceiling - y1, x2 - x1, y2 - y1);
    }

    public static double mapLin100(double value, double x1, double x2) {
        if (value <= 0.0) {
            return 0.0;
        }
        if (value >= 1.0) {
            return 1.0;
        }
        if (value <= x1) {
            return value * 25.0 / x1;
        }
        if (value <= x2) {
            return 25.0 + (value - x1) * 50.0 / (x2 - x1);
        }
        return 75.0 + (value - x2) * 25.0 / (1.0 - x2);
    }

    public static <T> List<MapToolkit.IntEntry<T>> calculateGroupingScore(IItemCollection items, IAccessorFactory<T> accessorFactory) {
        EntryHashMap map = MapToolkit.createIntMap((int)1000, (float)0.5f);
        for (IItemIterable ii : items) {
            IMemberAccessor accessor = accessorFactory.getAccessor(ii.getType());
            if (accessor == null) continue;
            for (IItem item : ii) {
                Object member = accessor.getMember((Object)item);
                if (member == null) continue;
                MapToolkit.IntEntry entry = (MapToolkit.IntEntry)map.get(member, true);
                entry.setValue(entry.getValue() + 1);
            }
        }
        List array = IteratorToolkit.toList((Iterator)map.iterator(), (int)map.size());
        Collections.sort(array);
        return array;
    }

    public static <T> double calculateBalanceScore(List<MapToolkit.IntEntry<T>> array) {
        int totalCount = 0;
        for (MapToolkit.IntEntry<T> e : array) {
            totalCount += e.getValue();
        }
        double score = 0.0;
        int i = array.size() - 1;
        while (i >= 0) {
            int index = array.size() - i;
            score += (double)array.get(i).getValue() / (double)totalCount / (double)index;
            --i;
        }
        return score;
    }

    public static void slidingWindowOrdered(IOrderedWindowVisitor callback, Iterator<IItem> items, IMemberAccessor<IQuantity, IItem> posAccessor, IQuantity windowSize, IQuantity slideSize) {
        IQuantity windowStart = null;
        ArrayList<IItem> windowItems = new ArrayList<IItem>();
        Iterator<IItem> iterator = items;
        block0: while (iterator.hasNext() && callback.shouldContinue()) {
            IItem item = iterator.next();
            windowStart = windowItems.isEmpty() ? (IQuantity)posAccessor.getMember((Object)item) : (IQuantity)posAccessor.getMember((Object)((IItem)windowItems.get(0)));
            windowItems.add(item);
            IQuantity windowEnd = (IQuantity)posAccessor.getMember((Object)item);
            while (iterator.hasNext() && windowEnd.subtract(windowSize).compareTo((Object)windowStart) < 0 && callback.shouldContinue()) {
                IItem next = iterator.next();
                windowEnd = (IQuantity)posAccessor.getMember((Object)next);
                windowItems.add(next);
            }
            callback.visitWindow(windowItems.iterator());
            if (slideSize == null) {
                if (windowItems.size() <= 1) continue;
                windowItems.remove(0);
                continue;
            }
            IQuantity newStart = windowStart.add(slideSize);
            Iterator it = windowItems.iterator();
            while (it.hasNext() && callback.shouldContinue()) {
                IItem wi = (IItem)it.next();
                if (((IQuantity)posAccessor.getMember((Object)wi)).compareTo((Object)newStart) >= 0) continue block0;
                it.remove();
            }
        }
    }

    public static void slidingWindowUnordered(IUnorderedWindowVisitor callback, IItemCollection items, IQuantity windowSize, IQuantity slideSize) {
        IQuantity first = (IQuantity)items.getAggregate(Aggregators.min((IAttribute)JfrAttributes.END_TIME));
        IQuantity last = (IQuantity)items.getAggregate(Aggregators.max((IAttribute)JfrAttributes.END_TIME));
        if (first == null) {
            return;
        }
        IQuantity windowStart = first;
        IQuantity windowEnd = windowStart.add(windowSize);
        do {
            IItemFilter window = ItemFilters.interval((ICanonicalAccessorFactory)JfrAttributes.END_TIME, (Comparable)windowStart, (boolean)true, (Comparable)windowEnd, (boolean)true);
            IItemCollection windowItems = items.apply(window);
            callback.visitWindow(windowItems, windowStart, windowEnd);
            windowStart = windowStart.add(slideSize);
            windowEnd = windowEnd.add(slideSize);
        } while (windowStart.compareTo((Object)last) < 0 && callback.shouldContinue());
    }

    public static double mapSigmoid(double input, double minimum, double maximum, double lowCurveFit, double inflectionPoint, double highCurveFit) {
        double g = Math.exp(lowCurveFit * (inflectionPoint - input));
        double h = Math.exp(highCurveFit * (inflectionPoint - input));
        return minimum + maximum / (1.0 + g + h);
    }

    private static Result getDisabledEventTypesResult(IRule rule, String disabledEventTypeNames) {
        return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_EVENTS"), rule.getName(), disabledEventTypeNames));
    }

    private static String getEventTypeNames(IItemCollection items) {
        Set names = (Set)items.getAggregate(Aggregators.distinct((String)"", TYPE_NAME_ACCESSOR_FACTORY));
        return names == null || names.isEmpty() ? null : StringToolkit.join((Collection)names, (String)", ");
    }

    private static IQuantity getSettingMaxPeriod(Iterable<String> settingsValues) {
        IQuantity maxPeriod = null;
        for (String s : settingsValues) {
            block4: {
                try {
                    if (!REC_SETTING_PERIOD_EVERY_CHUNK.equals(s)) break block4;
                    return null;
                }
                catch (QuantityConversionException e) {
                    throw new RuntimeException(e);
                }
            }
            IQuantity p = RulesToolkit.parsePersistedJvmTimespan(s);
            if (maxPeriod != null && maxPeriod.compareTo((Object)p) >= 0) continue;
            maxPeriod = p;
        }
        return maxPeriod;
    }

    private static Set<String> getPeriodSettings(IItemCollection items, String ... typeIds) {
        IItemFilter filter = RulesToolkit.getSettingsFilter(REC_SETTING_NAME_PERIOD, typeIds);
        return (Set)items.apply(filter).getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.REC_SETTING_VALUE));
    }

    private static String getDisabledEventTypeNames(IItemCollection items, String ... typeIds) {
        return RulesToolkit.getEventTypeNames(items.apply(RulesToolkit.createEnablementFilter(false, typeIds)));
    }

    private static IItemFilter createEnablementFilter(boolean enabled, String ... typeIds) {
        IItemFilter settingsFilter = RulesToolkit.getSettingsFilter(REC_SETTING_NAME_ENABLED, typeIds);
        IItemFilter enabledFilter = ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.REC_SETTING_VALUE, (Object)(enabled ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        IItemFilter enablementFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{settingsFilter, enabledFilter});
        return enablementFilter;
    }

    private static Result getRequiresEnabledEventTypesResult(IRule rule, IItemCollection items, String ... typeIds) {
        return RulesToolkit.getDisabledEventTypesResult(rule, RulesToolkit.getDisabledEventTypeNames(items, typeIds));
    }

    public static boolean isEmpty(IItemCollection items, String ... typeIds) {
        String[] stringArray = typeIds;
        int n = typeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String typeId = stringArray[n2];
            if (RulesToolkit.internalHasEvents(items, typeId)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean internalHasEvents(IItemCollection items, String typeId) {
        return items.apply(ItemFilters.type((String)typeId)).hasItems();
    }

    private static Set<String> getAvailableTypeIds(IItemCollection items) {
        HashSet<String> ids = new HashSet<String>();
        for (IItemIterable iterable : items) {
            ids.add(iterable.getType().getIdentifier());
        }
        return ids;
    }

    public static JavaVersion getJavaVersion(String vmInfoVersionString) {
        Matcher versionMatcher;
        if (vmInfoVersionString != null && (versionMatcher = VERSION_PATTERN.matcher(vmInfoVersionString)).matches()) {
            String versionString = versionMatcher.group(1);
            return new JavaVersion(versionString);
        }
        return null;
    }

    public static IType<IItem> getType(IItemCollection items, String typeId) {
        for (IItemIterable iter : items) {
            if (!iter.getType().getIdentifier().equals(typeId)) continue;
            return iter.getType();
        }
        return null;
    }

    public static Result getMissingAttributeResult(IRule rule, IType<IItem> type, IAttribute<?> attribute) {
        return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_ATTRIBUTE_NOT_FOUND"), attribute.getIdentifier(), type.getIdentifier()));
    }

    public static enum EventAvailability {
        AVAILABLE,
        ENABLED,
        DISABLED,
        NONE,
        UNAVAILABLE;

    }

    public static interface IOrderedWindowVisitor {
        public void visitWindow(Iterator<IItem> var1);

        public boolean shouldContinue();
    }

    public static interface IUnorderedWindowVisitor {
        public void visitWindow(IItemCollection var1, IQuantity var2, IQuantity var3);

        public boolean shouldContinue();
    }
}

