/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.report;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IItemQuery;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.util.ExceptionToolkit;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.LabeledIdentifier;
import com.oracle.jmc.common.util.XmlToolkit;
import com.oracle.jmc.flightrecorder.CouldNotLoadRecordingException;
import com.oracle.jmc.flightrecorder.JfrLoaderToolkit;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.RuleRegistry;
import com.oracle.jmc.flightrecorder.rules.Severity;
import com.oracle.jmc.flightrecorder.rules.report.JfrReportPermission;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.RunnableFuture;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JfrRulesReport {
    private static final Map<String, String> TRANSFORMS = new LinkedHashMap<String, String>();
    private static final JfrReportPermission OVERRIDE_PERMISSION = new JfrReportPermission("override");

    static {
        TRANSFORMS.put("html", "com/oracle/jmc/flightrecorder/rules/report/html.xslt");
        TRANSFORMS.put("text", "com/oracle/jmc/flightrecorder/rules/report/text.xslt");
    }

    private static void checkAccess(JfrReportPermission p) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(p);
        }
    }

    private static void checkOverrideAccess() throws SecurityException {
        JfrRulesReport.checkAccess(OVERRIDE_PERMISSION);
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws ParserConfigurationException, TransformerException {
        if (args.length == 0) {
            System.out.println("Enter one or more Java Flight Recorder file names as arguments to this program.");
            System.out.println();
            System.out.println("Optional arguments:");
            System.out.println();
            System.out.println(" -format <format>");
            System.out.println("    Selects an output format. Available formats are:");
            System.out.println("      xml (default)");
            for (String format : JfrRulesReport.TRANSFORMS.keySet()) {
                System.out.println("      " + format);
            }
            System.out.println();
            System.out.println(" -verbose");
            System.out.println("    Verbose output (including all events from rules).");
            System.out.println();
            System.out.println(" -min <severity>");
            System.out.println("    Minimum result severity to include in report.");
            System.out.println("    ok (default), info, or warning");
            System.out.println();
            System.out.println(" -override");
            System.out.println("    Allows overriding the default templates by looking for resources in the context loader.");
            return;
        }
        verbose = false;
        override = false;
        formatName = "xml";
        minSeverity = Severity.OK;
        fileNames = new ArrayList<String>();
        i = 0;
        while (i < args.length) {
            block16: {
                block15: {
                    if (!args[i].equals("-format")) break block15;
                    if (i >= args.length - 1) {
                        System.out.println("-format requires an output format argument, e.g. html");
                        return;
                    }
                    formatName = args[++i].toLowerCase(Locale.ENGLISH);
                    break block16;
                }
                if (!args[i].equalsIgnoreCase("-min")) ** GOTO lbl52
                if (i >= args.length - 1) {
                    System.out.println("-min requires an output format argument, e.g. ok");
                    return;
                }
                if ((minString = args[++i]).equalsIgnoreCase("ok")) {
                    minSeverity = Severity.OK;
                } else if (minString.equalsIgnoreCase("info")) {
                    minSeverity = Severity.INFO;
                } else if (minString.equalsIgnoreCase("warning")) {
                    minSeverity = Severity.WARNING;
                } else {
                    System.out.println("Unrecognized value of -min");
                    return;
lbl52:
                    // 1 sources

                    if (args[i].equalsIgnoreCase("-verbose")) {
                        verbose = true;
                    } else if (args[i].equalsIgnoreCase("-override")) {
                        override = true;
                    } else {
                        fileNames.add(args[i]);
                    }
                }
            }
            ++i;
        }
        JfrRulesReport.printReport(formatName, minSeverity, verbose, override, fileNames.toArray(new String[fileNames.size()]));
    }

    public static void printReport(String formatName, Severity minSeverity, boolean verbose, boolean override, String ... fileNames) throws ParserConfigurationException, TransformerException {
        InputStream xsltResourceStream;
        block9: {
            xsltResourceStream = null;
            if (formatName == null || formatName.equals("xml")) break block9;
            String xsltResourceName = TRANSFORMS.get(formatName);
            if (xsltResourceName != null) {
                if (override) {
                    JfrRulesReport.checkOverrideAccess();
                    xsltResourceStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(xsltResourceName);
                } else {
                    xsltResourceStream = JfrRulesReport.class.getClassLoader().getResourceAsStream(xsltResourceName);
                }
            }
            if (xsltResourceStream != null) break block9;
            System.out.println("Format not available: " + formatName);
            IOToolkit.closeSilently((Closeable)xsltResourceStream);
            return;
        }
        try {
            Transformer transformer;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("reportcollection");
            doc.appendChild(rootElement);
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                JfrRulesReport.addReport(fileName, minSeverity, verbose, rootElement);
                ++n2;
            }
            TransformerFactory transformerFactory = XmlToolkit.createTransformerFactory();
            if (xsltResourceStream != null) {
                StreamSource xsltSource = new StreamSource(xsltResourceStream);
                transformer = transformerFactory.newTransformer(xsltSource);
            } else {
                transformer = transformerFactory.newTransformer();
            }
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult console = new StreamResult(System.out);
            transformer.transform(source, console);
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(xsltResourceStream);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)xsltResourceStream);
    }

    public static void addReport(String fileName, Severity minSeverity, boolean verbose, Element parent) {
        try {
            File file = new File(fileName);
            Element reportNode = parent.getOwnerDocument().createElement("report");
            parent.appendChild(reportNode);
            reportNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "file", fileName));
            IItemCollection events = null;
            try {
                events = JfrLoaderToolkit.loadEvents((File)file);
            }
            catch (CouldNotLoadRecordingException | IOException e) {
                JfrRulesReport.addError(parent, reportNode, e);
                return;
            }
            for (IRule rule : RuleRegistry.getRules()) {
                Result result = null;
                try {
                    RunnableFuture<Result> future = rule.evaluate(events, IPreferenceValueProvider.DEFAULT_VALUES);
                    future.run();
                    result = (Result)future.get();
                }
                catch (Throwable t) {
                    Element ruleNode = JfrRulesReport.createRuleNode(parent, reportNode, rule);
                    JfrRulesReport.addError(parent, ruleNode, t);
                    continue;
                }
                if (result == null || Severity.get(result.getScore()).compareTo(minSeverity) < 0) continue;
                Element ruleNode = JfrRulesReport.createRuleNode(parent, reportNode, result.getRule());
                ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "severity", Severity.get(result.getScore()).getLocalizedName()));
                ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "score", String.valueOf(result.getScore())));
                ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "message", result.getShortDescription()));
                if (verbose) {
                    ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "detailedmessage", result.getLongDescription()));
                }
                IItemQuery itemQuery = result.getItemQuery();
                if (!verbose || itemQuery == null || itemQuery.getAttributes().isEmpty()) continue;
                Element itemSetNode = parent.getOwnerDocument().createElement("itemset");
                ruleNode.appendChild(itemSetNode);
                IItemCollection resultEvents = events.apply(itemQuery.getFilter());
                Collection attributes = itemQuery.getAttributes();
                Element fieldsNode = parent.getOwnerDocument().createElement("fields");
                itemSetNode.appendChild(fieldsNode);
                for (IAttribute attribute : attributes) {
                    Element fieldNode = parent.getOwnerDocument().createElement("field");
                    fieldsNode.appendChild(fieldNode);
                    fieldNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "name", attribute.getName()));
                }
                Element itemsNode = parent.getOwnerDocument().createElement("items");
                itemSetNode.appendChild(itemsNode);
                for (IItemIterable ii : resultEvents) {
                    IType type = ii.getType();
                    ArrayList<IMemberAccessor> accessors = new ArrayList<IMemberAccessor>(attributes.size());
                    for (IAttribute a : attributes) {
                        accessors.add(a.getAccessor(type));
                    }
                    for (IItem item : ii) {
                        Element itemNode = parent.getOwnerDocument().createElement("item");
                        itemsNode.appendChild(itemNode);
                        for (IMemberAccessor a : accessors) {
                            itemNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "value", JfrRulesReport.toString(a.getMember((Object)item))));
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            System.err.println("Got exception when creating report for " + fileName);
            throw t;
        }
    }

    private static String toString(Object member) {
        if (member instanceof IQuantity) {
            return ((IQuantity)member).displayUsing("auto");
        }
        if (member instanceof LabeledIdentifier) {
            return ((LabeledIdentifier)member).getName();
        }
        return String.valueOf(member);
    }

    private static void addError(Element parent, Element reportNode, Throwable t) {
        reportNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "error", ExceptionToolkit.toString((Throwable)t)));
    }

    private static Element createRuleNode(Element parent, Element reportNode, IRule rule) {
        Element ruleNode = parent.getOwnerDocument().createElement("rule");
        reportNode.appendChild(ruleNode);
        ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "id", rule.getId()));
        ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "name", rule.getName()));
        return ruleNode;
    }

    private static Element createValueNode(Document doc, String name, String value) {
        Element node = doc.createElement(name);
        node.appendChild(doc.createTextNode(value != null ? value : ""));
        return node;
    }
}

