/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules;

import com.oracle.jmc.flightrecorder.rules.messages.internal.Messages;

public enum Severity {
    NA(-1.0, Messages.getString("Severity_NOT_APPLICABLE")),
    OK(0.0, Messages.getString("Severity_OK")),
    INFO(25.0, Messages.getString("Severity_INFORMATION")),
    WARNING(75.0, Messages.getString("Severity_WARNING"));

    private final double score;
    private final String localizedName;
    private static final Severity[] VALUES;

    static {
        VALUES = new Severity[]{WARNING, INFO, OK, NA};
    }

    private Severity(double score, String localizedName) {
        this.score = score;
        this.localizedName = localizedName;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public double getLimit() {
        return this.score;
    }

    public static Severity get(double score) {
        Severity[] severityArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            Severity s = severityArray[n2];
            if (score >= s.score) {
                return s;
            }
            ++n2;
        }
        return NA;
    }
}

