/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules;

import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.internal.IRuleProvider;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuleRegistry {
    private static final Collection<IRule> RULES;

    static {
        HashMap<String, IRule> rulesById = new HashMap<String, IRule>();
        ServiceLoader<IRule> ruleLoader = ServiceLoader.load(IRule.class, IRule.class.getClassLoader());
        Iterator<IRule> ruleIter = ruleLoader.iterator();
        while (ruleIter.hasNext()) {
            try {
                IRule rule = ruleIter.next();
                RuleRegistry.add(rule, rulesById);
            }
            catch (ServiceConfigurationError e) {
                RuleRegistry.getLogger().log(Level.WARNING, "Could not create IRule instance specified in a JSL services file", e);
            }
        }
        ServiceLoader<IRuleProvider> providerLoader = ServiceLoader.load(IRuleProvider.class, IRuleProvider.class.getClassLoader());
        Iterator<IRuleProvider> providerIter = providerLoader.iterator();
        while (providerIter.hasNext()) {
            try {
                IRuleProvider provider = providerIter.next();
                for (IRule rule : provider.getRules()) {
                    RuleRegistry.add(rule, rulesById);
                }
            }
            catch (ServiceConfigurationError e) {
                RuleRegistry.getLogger().log(Level.WARNING, "Could not create IRuleProvider instance specified in a JSL services file", e);
            }
        }
        RULES = Collections.unmodifiableCollection(rulesById.values());
    }

    private RuleRegistry() {
    }

    private static Logger getLogger() {
        return Logger.getLogger("com.oracle.jmc.flightrecorder.rules");
    }

    private static void add(IRule rule, Map<String, IRule> rulesById) {
        if (rule != null) {
            if (!rulesById.containsKey(rule.getId())) {
                rulesById.put(rule.getId(), rule);
            } else {
                IRule firstRule = rulesById.get(rule.getId());
                RuleRegistry.getLogger().log(Level.WARNING, MessageFormat.format("Could not register rule \"{0}\" ({1}), because its id ({2}) conflicts with the rule \"{3}\" ({4}) which has already been registered", rule.getName(), rule.getClass().getName(), rule.getId(), firstRule.getName(), firstRule.getClass().getName()));
            }
        }
    }

    public static Collection<IRule> getRules() {
        return RULES;
    }
}

