/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.persistence.editors;

import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.console.persistence.PersistencePlugin;
import com.oracle.jmc.console.persistence.editors.InformationSectionPart;
import com.oracle.jmc.console.persistence.editors.Messages;
import com.oracle.jmc.console.persistence.editors.PersistenceEditorInput;
import com.oracle.jmc.console.persistence.editors.PersistenceMetadataService;
import com.oracle.jmc.console.ui.actions.ResetToDefaultsAction;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.persistence.internal.PersistenceReader;
import com.oracle.jmc.rjmx.services.IAttributeStorageService;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataService;
import com.oracle.jmc.rjmx.subscription.IMRIService;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.ui.RJMXUIPlugin;
import com.oracle.jmc.rjmx.ui.internal.CombinedChartSectionPart;
import com.oracle.jmc.rjmx.ui.internal.SectionPartManager;
import com.oracle.jmc.ui.MCPathEditorInput;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.misc.MCActionContributionItem;
import com.oracle.jmc.ui.misc.MCSectionPart;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.EditorPart;

public class PersistenceEditor
extends EditorPart {
    public static final String EDITOR_ID = "com.oracle.jmc.console.persistence.editors.PersistenceEditor";
    private static final String HELP_CONTEXT_ID = "com.oracle.jmc.console.persistence.PersistenceEditor";
    private static final String TAB_ID = "PersistencePage";
    private static final String CHART_SECTION_ID = "chartSection";
    private static final int DEFAULT_MAX_NO_CHARTS = 3;
    private static final int DEFAULT_MAX_NO_ATTRIBUTES = 100;
    private String serverUid;
    private File persistenceDirectory;
    private ManagedForm managedForm;

    public Image getTitleImage() {
        return PersistencePlugin.getDefault().getImage("persistence-16.gif");
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = UIPlugin.getDefault().getFormToolkit();
        ScrolledForm form = toolkit.createScrolledForm(parent);
        this.managedForm = new ManagedForm(toolkit, form);
        this.managedForm.getForm().setImage(this.getTitleImage());
        this.managedForm.getForm().setText(Messages.PersistencePage_TITLE);
        toolkit.decorateFormHeading(this.managedForm.getForm().getForm());
        final PersistenceReader reader = new PersistenceReader(this.persistenceDirectory, this.serverUid);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, HELP_CONTEXT_ID);
        if (reader.getMRIs().isEmpty()) {
            InformationSectionPart.fill(form.getBody(), toolkit);
        } else {
            final SectionPartManager sectionPartManager = new SectionPartManager((IManagedForm)this.managedForm);
            final PersistenceMetadataService mds = new PersistenceMetadataService((IMRIMetadataService)RJMXPlugin.getDefault().getService(IMRIMetadataService.class));
            Action newChartAction = new Action(Messages.NewChartAction_ADD_CHART_TEXT, RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj.gif")){

                public void run() {
                    PersistenceEditor.createChart(sectionPartManager, reader, mds, sectionPartManager.createUniqueSectionPartTitle(Messages.NewChartAction_MY_CHART_X_TEXT), null);
                }
            };
            IToolBarManager toolbar = form.getToolBarManager();
            toolbar.add((IContributionItem)new MCActionContributionItem((IAction)new ResetToDefaultsAction(){

                protected void reset() {
                    sectionPartManager.destroyAllParts();
                    PersistenceEditor.addDefaultCharts(sectionPartManager, reader, mds);
                }
            }));
            toolbar.add((IContributionItem)new MCActionContributionItem((IAction)newChartAction));
            toolbar.update(true);
            IMemento configuration = this.getConfiguration();
            if (configuration == null) {
                PersistenceEditor.addDefaultCharts(sectionPartManager, reader, mds);
            } else {
                IMemento[] iMementoArray = configuration.getChildren(CHART_SECTION_ID);
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento cs = iMementoArray[n2];
                    PersistenceEditor.createChart(sectionPartManager, reader, mds, null, cs);
                    ++n2;
                }
            }
        }
    }

    private IMemento getConfiguration() {
        if (this.serverUid == null) {
            return null;
        }
        try {
            return XMLMemento.createReadRoot((Reader)new StringReader(RJMXPlugin.getDefault().getServerPreferences(this.serverUid).get(TAB_ID, "")));
        }
        catch (WorkbenchException e) {
            return null;
        }
    }

    public void dispose() {
        if (this.serverUid != null && this.managedForm.getParts().length > 0) {
            XMLMemento state = XMLMemento.createWriteRoot((String)TAB_ID);
            IFormPart[] iFormPartArray = this.managedForm.getParts();
            int n = iFormPartArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPart part = iFormPartArray[n2];
                if (part instanceof CombinedChartSectionPart) {
                    ((CombinedChartSectionPart)part).saveState(state.createChild(CHART_SECTION_ID));
                }
                ++n2;
            }
            StringWriter sw = new StringWriter();
            try {
                state.save((Writer)sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            RJMXPlugin.getDefault().getServerPreferences(this.serverUid).put(TAB_ID, sw.toString());
        }
        super.dispose();
    }

    private static void addDefaultCharts(SectionPartManager spm, PersistenceReader pr, IMRIMetadataService mds) {
        HashMap mrisByKind = new HashMap();
        for (MRI mri : pr.getMRIs()) {
            KindOfQuantity kind = UnitLookup.getUnitOrDefault((String)mds.getMetadata(mri).getUnitString()).getContentType();
            ArrayList<MRI> list = (ArrayList<MRI>)mrisByKind.get(kind);
            if (list == null) {
                list = new ArrayList<MRI>();
                mrisByKind.put(kind, list);
            }
            if (list.size() >= 100) continue;
            list.add(mri);
        }
        ArrayList allAttributes = new ArrayList(mrisByKind.entrySet());
        Collections.sort(allAttributes, new Comparator<Map.Entry<KindOfQuantity<?>, List<MRI>>>(){

            @Override
            public int compare(Map.Entry<KindOfQuantity<?>, List<MRI>> e1, Map.Entry<KindOfQuantity<?>, List<MRI>> e2) {
                return e2.getValue().size() - e1.getValue().size();
            }
        });
        int i = 0;
        while (i < 3 && i < allAttributes.size()) {
            Map.Entry e = (Map.Entry)allAttributes.get(i);
            List l = (List)e.getValue();
            PersistenceEditor.createChart(spm, pr, mds, ((KindOfQuantity)e.getKey()).getName(), null).add(l.toArray(new MRI[l.size()]));
            ++i;
        }
    }

    private static CombinedChartSectionPart createChart(SectionPartManager spm, PersistenceReader pr, IMRIMetadataService mds, String title, IMemento state) {
        CombinedChartSectionPart hcsp = new CombinedChartSectionPart(spm.getContainer(), spm.getFormToolkit(), 322, mds, (IMRIService)pr, (IAttributeStorageService)pr, state){

            protected Consumer<Boolean> createEnableUpdatesCallback() {
                return b -> {};
            }
        };
        spm.add((MCSectionPart)hcsp, true, true);
        if (title != null) {
            hcsp.getChart().getChartModel().setChartTitle(title);
            hcsp.getChart().getChartModel().notifyObservers();
        }
        hcsp.getChart().showLast(3600000000000L);
        return hcsp;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        File logFile = MCPathEditorInput.getFile((IEditorInput)input);
        if (logFile != null) {
            File attributeDir = logFile.getParentFile();
            if (attributeDir != null) {
                this.persistenceDirectory = attributeDir.getParentFile();
            }
        } else if (input instanceof PersistenceEditorInput) {
            this.serverUid = ((PersistenceEditorInput)input).getUid();
        }
    }

    public void setFocus() {
        this.managedForm.getForm().setFocus();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }
}

