/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.version;

public class JavaVersion {
    private final int[] versionNumbers;
    private final boolean isEarlyAccess;
    public static final int UNKNOWN = -1;

    public JavaVersion(String version) {
        String[] numbers = version.split("[\\._]");
        int offset = 0;
        int versionNumbersLength = numbers.length;
        if (numbers.length > 0 && this.parseNumber(0, numbers) == 1) {
            offset = 1;
            versionNumbersLength = numbers.length - 1;
        }
        this.versionNumbers = new int[versionNumbersLength];
        int i = 0;
        while (i < versionNumbersLength) {
            this.versionNumbers[i] = this.parseNumber(i + offset, numbers);
            ++i;
        }
        this.isEarlyAccess = version.contains("ea");
    }

    public JavaVersion(int ... versionNumbers) {
        this(false, versionNumbers);
    }

    public JavaVersion(boolean isEarlyAccess, int ... versionNumbers) {
        this.versionNumbers = versionNumbers;
        this.isEarlyAccess = isEarlyAccess;
    }

    private int parseNumber(int index, String[] numbers) {
        if (index + 1 > numbers.length) {
            return -1;
        }
        StringBuilder numberStringBuilder = new StringBuilder();
        int i = 0;
        while (i < numbers[index].length()) {
            char c = numbers[index].charAt(i);
            if (!Character.isDigit(c)) break;
            numberStringBuilder.append(c);
            ++i;
        }
        try {
            return Integer.parseInt(numberStringBuilder.toString());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int[] nArray = this.versionNumbers;
        int n = this.versionNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            int versionNumber = nArray[n2];
            result = 31 * result + versionNumber;
            ++n2;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaVersion other = (JavaVersion)obj;
        return this.isGreaterOrEqualThan(other) && other.isGreaterOrEqualThan(this);
    }

    public boolean isGreaterOrEqualThan(JavaVersion otherVersion) {
        int maxLength = Math.max(this.versionNumbers.length, otherVersion.versionNumbers.length);
        int i = 0;
        while (i < maxLength) {
            int otherNumber;
            int thisNumber = this.versionNumbers.length > i ? this.versionNumbers[i] : 0;
            int n = otherNumber = otherVersion.versionNumbers.length > i ? otherVersion.versionNumbers[i] : 0;
            if (thisNumber != otherNumber) {
                return thisNumber > otherNumber;
            }
            ++i;
        }
        return !this.isEarlyAccess || otherVersion.isEarlyAccess;
    }

    public boolean isSameMajorVersion(JavaVersion otherVersion) {
        return otherVersion != null && this.versionNumbers.length > 0 && otherVersion.versionNumbers.length > 0 && this.versionNumbers[0] == otherVersion.versionNumbers[0];
    }

    public int getMajorVersion() {
        return this.versionNumbers[0];
    }

    public String toString() {
        if (this.versionNumbers.length == 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append(this.versionNumbers[0]);
        int i = 1;
        while (i < this.versionNumbers.length) {
            b.append('.');
            b.append(this.versionNumbers[i]);
            ++i;
        }
        return b.toString();
    }

    public boolean isEarlyAccess() {
        return this.isEarlyAccess;
    }
}

