/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.util;

import com.oracle.jmc.common.IDescribable;
import com.oracle.jmc.common.IDisplayable;
import com.oracle.jmc.common.IMCClassLoader;
import com.oracle.jmc.common.IMCMethod;
import com.oracle.jmc.common.IMCType;
import com.oracle.jmc.common.messages.internal.Messages;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.ClassLoaderToolkit;
import com.oracle.jmc.common.util.FormatToolkit;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public final class TypeHandling {
    private static final HashMap<String, String> formalPrimitiveMap = new HashMap();
    private static final String VALUE_COMPOSITE_DATA = "CompositeData";
    private static final String VALUE_TABULAR_DATA = "TabularData";
    private static HashMap<String, Class<?>> primitiveNameToClassMap;
    private static HashMap<Class<?>, Class<?>> primitiveToObjectClassMap;

    static {
        formalPrimitiveMap.put("B", "byte");
        formalPrimitiveMap.put("C", "char");
        formalPrimitiveMap.put("D", "double");
        formalPrimitiveMap.put("F", "float");
        formalPrimitiveMap.put("I", "int");
        formalPrimitiveMap.put("J", "long");
        formalPrimitiveMap.put("S", "short");
        formalPrimitiveMap.put("Z", "boolean");
        primitiveNameToClassMap = new HashMap();
        primitiveNameToClassMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveNameToClassMap.put(Long.TYPE.getName(), Long.TYPE);
        primitiveNameToClassMap.put(Short.TYPE.getName(), Short.TYPE);
        primitiveNameToClassMap.put(Character.TYPE.getName(), Character.TYPE);
        primitiveNameToClassMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveNameToClassMap.put(Float.TYPE.getName(), Float.TYPE);
        primitiveNameToClassMap.put(Double.TYPE.getName(), Double.TYPE);
        primitiveNameToClassMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveToObjectClassMap = new HashMap();
        primitiveToObjectClassMap.put(Integer.TYPE, Integer.class);
        primitiveToObjectClassMap.put(Long.TYPE, Long.class);
        primitiveToObjectClassMap.put(Short.TYPE, Short.class);
        primitiveToObjectClassMap.put(Character.TYPE, Character.class);
        primitiveToObjectClassMap.put(Byte.TYPE, Byte.class);
        primitiveToObjectClassMap.put(Float.TYPE, Float.class);
        primitiveToObjectClassMap.put(Double.TYPE, Double.class);
        primitiveToObjectClassMap.put(Boolean.TYPE, Boolean.class);
    }

    private TypeHandling() {
    }

    public static String simplifyType(String typeName) {
        if (typeName == null) {
            return "null";
        }
        StringBuilder arrayBuilder = new StringBuilder();
        while (typeName.startsWith("[")) {
            typeName = typeName.substring(1);
            arrayBuilder.append("[]");
        }
        if (typeName.endsWith(";")) {
            typeName = typeName.substring(1, typeName.length() - 1);
        }
        if (typeName.equals(CompositeData.class.getName())) {
            typeName = VALUE_COMPOSITE_DATA;
        } else if (typeName.equals(TabularData.class.getName())) {
            typeName = VALUE_TABULAR_DATA;
        } else if (typeName.equals(String.class.getName())) {
            typeName = "String";
        } else if (formalPrimitiveMap.containsKey(typeName)) {
            typeName = formalPrimitiveMap.get(typeName);
        } else if (typeName.startsWith("java.lang.") && typeName.lastIndexOf(46) == 9) {
            typeName = typeName.substring(10);
        }
        return String.valueOf(typeName) + arrayBuilder.toString();
    }

    private static String createSizeString(String typeName, int size) {
        return MessageFormat.format(Messages.getString("TypeHandling_MESSAGE_SIZE"), typeName, size);
    }

    public static String getValueString(Object value) {
        if (value != null) {
            if (value instanceof CompositeData) {
                return TypeHandling.createSizeString(VALUE_COMPOSITE_DATA, ((CompositeData)value).values().size());
            }
            if (value instanceof TabularData) {
                return TypeHandling.createSizeString(VALUE_TABULAR_DATA, ((TabularData)value).size());
            }
            if (value.getClass().isArray()) {
                String typeString = TypeHandling.simplifyType(value.getClass().getName());
                int firstBracketIndex = typeString.indexOf(91);
                return String.valueOf(typeString.substring(0, firstBracketIndex + 1)) + Array.getLength(value) + typeString.substring(firstBracketIndex + 1);
            }
            if (value instanceof Collection) {
                return TypeHandling.createSizeString(value.getClass().getName(), ((Collection)value).size());
            }
            if (value instanceof Map) {
                return TypeHandling.createSizeString(value.getClass().getName(), ((Map)value).size());
            }
            if (TypeHandling.isMaxTimespan(value)) {
                return "\u221e";
            }
            if (value instanceof IDisplayable) {
                return ((IDisplayable)value).displayUsing("auto");
            }
            if (value instanceof IDescribable) {
                return ((IDescribable)value).getName();
            }
            if (value instanceof Date) {
                return DateFormat.getDateTimeInstance().format(value);
            }
            if (value instanceof IMCType) {
                return FormatToolkit.getType((IMCType)value, true);
            }
            if (value instanceof IMCMethod) {
                return FormatToolkit.getHumanReadable((IMCMethod)value, true, false, true, true, true, false);
            }
            if (value instanceof IMCClassLoader) {
                return ClassLoaderToolkit.format((IMCClassLoader)value);
            }
            return value.toString();
        }
        return "null";
    }

    private static boolean isMaxTimespan(Object value) {
        IQuantity q;
        return value instanceof IQuantity && (q = (IQuantity)value).getType() == UnitLookup.TIMESPAN && q.longValue() == Long.MAX_VALUE;
    }

    public static Class<?> getClassWithName(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("The class name may not be null!");
        }
        Class<?> c = primitiveNameToClassMap.get(name);
        if (c == null) {
            return Class.forName(name);
        }
        return c;
    }

    public static Class<?> toNonPrimitiveClass(Class<?> primitiveClass) {
        if (primitiveClass.isPrimitive()) {
            return primitiveToObjectClassMap.get(primitiveClass);
        }
        return primitiveClass;
    }

    public static boolean isPrimitive(String className) {
        return primitiveNameToClassMap.containsKey(className);
    }

    public static <T> T cast(Object o, Class<T> type) {
        return type.isInstance(o) ? (T)type.cast(o) : null;
    }
}

