/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.util;

import com.oracle.jmc.common.io.IOToolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;

public final class StringToolkit {
    private StringToolkit() {
        throw new AssertionError((Object)"This is not the constructor you are looking for!");
    }

    public static String readString(InputStream in) throws IOException {
        return StringToolkit.readString(new BufferedReader(new InputStreamReader(in), 8192));
    }

    public static String readString(InputStream in, String charsetName) throws IOException {
        return StringToolkit.readString(new BufferedReader(new InputStreamReader(in, charsetName), 8192));
    }

    private static String readString(BufferedReader reader) throws IOException {
        String s;
        StringBuilder builder = new StringBuilder();
        try {
            while ((s = reader.readLine()) != null) {
                builder.append(String.valueOf(s) + "\r");
            }
            s = builder.toString();
        }
        finally {
            IOToolkit.closeSilently(reader);
        }
        return s;
    }

    public static String readString(File f) throws IOException {
        FileInputStream is = new FileInputStream(f);
        try {
            String string = StringToolkit.readString(is);
            return string;
        }
        finally {
            IOToolkit.closeSilently(is);
        }
    }

    public static String encodeFilename(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return string.replaceAll("\\W+", "-");
        }
    }

    public static String join(Collection<?> s, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = s.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) break;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String join(Object[] a, String delimiter) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < a.length - 1) {
            builder.append(String.valueOf(a[i]));
            builder.append(delimiter);
            ++i;
        }
        builder.append(a[a.length - 1]);
        return builder.toString();
    }
}

