/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.util;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IStateful;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.util.StateElement;
import com.oracle.jmc.common.util.StateElementWriter;
import com.oracle.jmc.common.util.StateHandler;
import com.oracle.jmc.common.util.XmlToolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StateToolkit {
    public static void saveXMLDocumentTo(Reader documentReader, IWritableState dst) throws SAXException, IOException, ParserConfigurationException {
        SAXParser parser = XmlToolkit.createSAXParserFactory().newSAXParser();
        parser.parse(new InputSource(documentReader), (DefaultHandler)new StateHandler(dst));
    }

    public static IState fromXMLString(String document) throws SAXException {
        return new StateElement(XmlToolkit.loadDocumentFromString(document).getDocumentElement());
    }

    public static IStateful statefulFromXMLString(final String document) {
        return new IStateful(){

            @Override
            public void saveTo(IWritableState state) {
                try {
                    StateToolkit.saveXMLDocumentTo(new StringReader(document), state);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read state from XML string", e);
                }
            }
        };
    }

    public static IStateful statefulFromXMLFile(final File document, final Charset charset) {
        return new IStateful(){

            @Override
            public void saveTo(IWritableState state) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileInputStream fis = new FileInputStream(document);){
                        StateToolkit.saveXMLDocumentTo(new InputStreamReader((InputStream)fis, charset), state);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read state from XML string", e);
                }
            }
        };
    }

    public static IState fromXMLFile(File document) throws SAXException, IOException {
        return new StateElement(XmlToolkit.loadDocumentFromFile(document).getDocumentElement());
    }

    public static IState create(Element element) {
        return new StateElement(element);
    }

    public static IWritableState createWriter(String rootName) throws IOException {
        return new StateElementWriter(rootName);
    }

    public static String toXMLString(IStateful state) {
        try {
            StringWriter wrt = new StringWriter();
            StateToolkit.writeAsXml(state, wrt);
            return wrt.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeAsXml(IStateful state, Writer to) throws IOException {
        StateElementWriter stateWriter = new StateElementWriter("state");
        state.saveTo(stateWriter);
        stateWriter.write(to);
    }

    public static void writeBoolean(IWritableState dst, String attribute, Boolean value) {
        if (value != null) {
            dst.putString(attribute, Boolean.toString(value));
        }
    }

    public static Boolean readBoolean(IState src, String attribute, Boolean defaultValue) {
        if (src == null) {
            return defaultValue;
        }
        String v = src.getAttribute(attribute);
        if (v == null) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(v)) {
            return true;
        }
        if ("false".equalsIgnoreCase(v)) {
            return false;
        }
        return defaultValue;
    }

    public static void writeFloat(IWritableState dst, String attribute, Float value) {
        if (value != null) {
            dst.putString(attribute, Float.toString(value.floatValue()));
        }
    }

    public static Float readFloat(IState src, String attribute, Float defaultValue) {
        if (src == null) {
            return defaultValue;
        }
        String v = src.getAttribute(attribute);
        if (v != null) {
            try {
                return Float.valueOf(Float.parseFloat(v));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void writeInt(IWritableState dst, String attribute, Integer value) {
        if (value != null) {
            dst.putString(attribute, Integer.toString(value));
        }
    }

    public static Integer readInt(IState src, String attribute, Integer defaultValue) {
        if (src == null) {
            return defaultValue;
        }
        String v = src.getAttribute(attribute);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static <T extends Enum<T>> void writeEnum(IWritableState dst, String attribute, T value) {
        if (value != null) {
            dst.putString(attribute, value.name());
        }
    }

    public static <T extends Enum<T>> T readEnum(IState src, String attribute, T defaultValue, Class<T> klass) {
        if (src == null) {
            return defaultValue;
        }
        String v = src.getAttribute(attribute);
        try {
            return v == null ? defaultValue : Enum.valueOf(klass, v);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

