/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.util;

import com.oracle.jmc.common.IWritableState;
import java.util.Deque;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class StateHandler
extends DefaultHandler {
    private final IWritableState documentElement;
    private final Deque<IWritableState> stateStack = new LinkedList<IWritableState>();

    public StateHandler(IWritableState state) {
        this.documentElement = state;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        IWritableState state = this.stateStack.isEmpty() ? this.documentElement : this.stateStack.peek().createChild(qName);
        int i = 0;
        while (i < attributes.getLength()) {
            state.putString(attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        this.stateStack.push(state);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.stateStack.pop();
    }
}

