/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.util;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.IPredicate;
import com.oracle.jmc.common.unit.IRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PredicateToolkit {
    private static final IPredicate<Object> FALSE = new IPredicate<Object>(){

        @Override
        public boolean evaluate(Object o) {
            return false;
        }
    };
    private static final IPredicate<Object> TRUE = new IPredicate<Object>(){

        @Override
        public boolean evaluate(Object o) {
            return true;
        }
    };

    public static <T> IPredicate<T> truePredicate() {
        return TRUE;
    }

    public static <T> IPredicate<T> falsePredicate() {
        return FALSE;
    }

    public static boolean isTrueGuaranteed(IPredicate<?> p) {
        return p == TRUE;
    }

    public static boolean isFalseGuaranteed(IPredicate<?> p) {
        return p == FALSE;
    }

    public static <T> IPredicate<T> and(Collection<IPredicate<T>> expressions) {
        switch (expressions.size()) {
            case 0: {
                return PredicateToolkit.truePredicate();
            }
            case 1: {
                return expressions.iterator().next();
            }
        }
        final ArrayList<IPredicate<T>> nonTrivialPredicates = new ArrayList<IPredicate<T>>(expressions.size());
        for (IPredicate<T> p : expressions) {
            if (PredicateToolkit.isFalseGuaranteed(p)) {
                return p;
            }
            if (PredicateToolkit.isTrueGuaranteed(p)) continue;
            nonTrivialPredicates.add(p);
        }
        if (nonTrivialPredicates.size() == 0) {
            return PredicateToolkit.truePredicate();
        }
        if (nonTrivialPredicates.size() == 1) {
            return (IPredicate)nonTrivialPredicates.get(0);
        }
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                for (IPredicate ex : nonTrivialPredicates) {
                    if (ex.evaluate(o)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> IPredicate<T> or(Collection<IPredicate<T>> expressions) {
        switch (expressions.size()) {
            case 0: {
                return PredicateToolkit.falsePredicate();
            }
            case 1: {
                return expressions.iterator().next();
            }
        }
        final ArrayList<IPredicate<T>> nonTrivialPredicates = new ArrayList<IPredicate<T>>(expressions.size());
        for (IPredicate<T> p : expressions) {
            if (PredicateToolkit.isTrueGuaranteed(p)) {
                return p;
            }
            if (PredicateToolkit.isFalseGuaranteed(p)) continue;
            nonTrivialPredicates.add(p);
        }
        if (nonTrivialPredicates.size() == 0) {
            return PredicateToolkit.falsePredicate();
        }
        if (nonTrivialPredicates.size() == 1) {
            return (IPredicate)nonTrivialPredicates.get(0);
        }
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                for (IPredicate ex : nonTrivialPredicates) {
                    if (!ex.evaluate(o)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> IPredicate<T> not(final IPredicate<T> predicate) {
        if (PredicateToolkit.isTrueGuaranteed(predicate)) {
            return PredicateToolkit.falsePredicate();
        }
        if (PredicateToolkit.isFalseGuaranteed(predicate)) {
            return PredicateToolkit.truePredicate();
        }
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                return !predicate.evaluate(o);
            }
        };
    }

    public static <T, M> IPredicate<T> less(boolean orEqual, IMemberAccessor<? extends M, T> field, Comparable<? super M> limit) {
        return orEqual ? PredicateToolkit.lessOrEqual(field, limit) : PredicateToolkit.less(field, limit);
    }

    public static <T, M> IPredicate<T> less(final IMemberAccessor<? extends M, T> field, final Comparable<? super M> limit) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                Object value = field.getMember(o);
                return value != null && limit.compareTo(value) > 0;
            }
        };
    }

    public static <T, M> IPredicate<T> lessOrEqual(final IMemberAccessor<? extends M, T> field, final Comparable<? super M> limit) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                Object value = field.getMember(o);
                return value != null && limit.compareTo(value) >= 0;
            }
        };
    }

    public static <T, M> IPredicate<T> more(boolean orEqual, IMemberAccessor<? extends M, T> field, Comparable<? super M> limit) {
        return orEqual ? PredicateToolkit.moreOrEqual(field, limit) : PredicateToolkit.more(field, limit);
    }

    public static <T, M> IPredicate<T> more(final IMemberAccessor<? extends M, T> field, final Comparable<? super M> limit) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                Object value = field.getMember(o);
                return value != null && limit.compareTo(value) < 0;
            }
        };
    }

    public static <T, M> IPredicate<T> moreOrEqual(final IMemberAccessor<? extends M, T> field, final Comparable<? super M> limit) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                Object value = field.getMember(o);
                return value != null && limit.compareTo(value) <= 0;
            }
        };
    }

    public static <T, M extends Comparable<? super M>> IPredicate<T> rangeIntersects(final IMemberAccessor<? extends IRange<M>, T> rangeAccessor, final IRange<M> limit) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                IRange value = (IRange)rangeAccessor.getMember(o);
                if (value != null) {
                    return value.getStart().compareTo(limit.getEnd()) <= 0 && value.getEnd().compareTo(limit.getStart()) >= 0;
                }
                return false;
            }
        };
    }

    public static <T, M extends Comparable<? super M>> IPredicate<T> rangeContained(final IMemberAccessor<? extends IRange<M>, T> rangeAccessor, final IRange<M> limit) {
        if (limit.isPoint()) {
            M point = limit.getStart();
            return new IPredicate<T>((Comparable)point){
                private final /* synthetic */ Comparable val$point;
                {
                    this.val$point = comparable;
                }

                @Override
                public boolean evaluate(T o) {
                    IRange value = (IRange)rangeAccessor.getMember(o);
                    return value != null && value.isPoint() && this.val$point.compareTo(value.getStart()) == 0;
                }
            };
        }
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                IRange value = (IRange)rangeAccessor.getMember(o);
                if (value != null) {
                    return value.getStart().compareTo(limit.getStart()) >= 0 && value.getEnd().compareTo(limit.getEnd()) <= 0;
                }
                return false;
            }
        };
    }

    public static <T, M extends Comparable<? super M>> IPredicate<T> centerContained(final IMemberAccessor<? extends IRange<M>, T> rangeAccessor, final IRange<M> limit) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                IRange value = (IRange)rangeAccessor.getMember(o);
                if (value != null) {
                    Object center = value.getCenter();
                    return center.compareTo(limit.getStart()) >= 0 && center.compareTo(limit.getEnd()) < 0;
                }
                return false;
            }
        };
    }

    public static <T> IPredicate<T> equals(final IMemberAccessor<?, T> field, final Object object) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                Object value = field.getMember(o);
                return object == null ? value == null : object.equals(value);
            }
        };
    }

    public static <T> IPredicate<T> notEquals(final IMemberAccessor<?, T> field, final Object object) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                Object value = field.getMember(o);
                return object == null ? value != null : !object.equals(value);
            }
        };
    }

    public static <T> IPredicate<T> is(final T item) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                return o == item;
            }
        };
    }

    public static <T> IPredicate<T> includedIn(final Set<? extends T> items) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                return items.contains(o);
            }
        };
    }

    public static <T, M> IPredicate<T> memberOf(final IMemberAccessor<? extends M, T> field, final Set<? extends M> values) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                Object value = field.getMember(o);
                return values.contains(value);
            }
        };
    }

    public static <T> IPredicate<T> matches(final IMemberAccessor<? extends String, T> field, String regexp) {
        final Pattern pattern = PredicateToolkit.getValidPattern(regexp);
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                String value = (String)field.getMember(o);
                return value == null ? false : pattern.matcher(value).matches();
            }
        };
    }

    public static <T> IPredicate<T> contains(final IMemberAccessor<? extends String, T> field, final String substring) {
        return new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                String value = (String)field.getMember(o);
                return value == null ? false : value.contains(substring);
            }
        };
    }

    public static Pattern getValidPattern(String regexp) {
        try {
            return Pattern.compile(regexp, 32);
        }
        catch (PatternSyntaxException pse) {
            Logger.getLogger("com.oracle.jmc.common.util").log(Level.FINE, "Got exception when compiling regular expression: " + pse.getMessage(), pse);
            return Pattern.compile("$.");
        }
    }
}

