/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.util;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.common.IMCMethod;
import com.oracle.jmc.common.util.MCMethod;

public class MCFrame
implements IMCFrame {
    private final IMCMethod m_method;
    private final Integer m_bci;
    private final Integer m_frameLineNumber;
    private final IMCFrame.Type m_type;

    public MCFrame(IMCMethod method, Integer bci, Integer frameLineNumber, IMCFrame.Type type) {
        this.m_method = method == null ? new MCMethod(null, "", "()V;", null, false) : method;
        this.m_bci = bci;
        this.m_frameLineNumber = frameLineNumber;
        this.m_type = type;
    }

    @Override
    public final Integer getBCI() {
        return this.m_bci;
    }

    @Override
    public final IMCMethod getMethod() {
        return this.m_method;
    }

    @Override
    public final Integer getFrameLineNumber() {
        return this.m_frameLineNumber;
    }

    @Override
    public final IMCFrame.Type getType() {
        return this.m_type;
    }

    public String toString() {
        return this.m_method + " " + (Object)((Object)this.m_type) + " " + this.m_frameLineNumber + " " + (Object)((Object)this.m_type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_bci == null ? 0 : this.m_bci.hashCode());
        result = 31 * result + (this.m_frameLineNumber == null ? 0 : this.m_frameLineNumber.hashCode());
        result = 31 * result + (this.m_method == null ? 0 : this.m_method.hashCode());
        result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MCFrame other = (MCFrame)obj;
        if (this.m_bci == null ? other.m_bci != null : !this.m_bci.equals(other.m_bci)) {
            return false;
        }
        if (this.m_frameLineNumber == null ? other.m_frameLineNumber != null : !this.m_frameLineNumber.equals(other.m_frameLineNumber)) {
            return false;
        }
        if (this.m_method == null ? other.m_method != null : !this.m_method.equals(other.m_method)) {
            return false;
        }
        return this.m_type == other.m_type;
    }
}

